/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.DatabaseSaver;
import weka.core.converters.FileSourcedConverter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.Saver;

public class SaverCustomizer
extends JPanel
implements Customizer,
CustomizerCloseRequester {
    private static final long serialVersionUID = -4874208115942078471L;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private Saver m_dsSaver;
    private PropertySheetPanel m_SaverEditor = new PropertySheetPanel();
    private JFileChooser m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    private JFrame m_parentFrame;
    private JTextField m_dbaseURLText;
    private JTextField m_userNameText;
    private JPasswordField m_passwordText;
    private JTextField m_tableText;
    private JComboBox m_idBox;
    private JComboBox m_tabBox;
    private JTextField m_prefixText;
    private JCheckBox m_relativeFilePath;
    private JCheckBox m_relationNameForFilename;

    public SaverCustomizer() {
        try {
            this.m_SaverEditor.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    SaverCustomizer.this.repaint();
                    if (SaverCustomizer.this.m_dsSaver != null) {
                        System.err.println("Property change!!");
                        SaverCustomizer.this.m_dsSaver.setSaver(SaverCustomizer.this.m_dsSaver.getSaver());
                    }
                }
            });
            this.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLayout(new BorderLayout());
        this.m_fileChooser.setDialogType(1);
        this.m_fileChooser.setFileSelectionMode(1);
        this.m_fileChooser.setApproveButtonText("Select directory and prefix");
        this.m_fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ApproveSelection")) {
                    try {
                        SaverCustomizer.this.m_dsSaver.getSaver().setFilePrefix(SaverCustomizer.this.m_prefixText.getText());
                        SaverCustomizer.this.m_dsSaver.getSaver().setDir(SaverCustomizer.this.m_fileChooser.getSelectedFile().getPath());
                        SaverCustomizer.this.m_dsSaver.setRelationNameForFilename(SaverCustomizer.this.m_relationNameForFilename.isSelected());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (SaverCustomizer.this.m_parentFrame != null) {
                    SaverCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
    }

    public void setParentFrame(JFrame parent) {
        this.m_parentFrame = parent;
    }

    private void setUpOther() {
        this.removeAll();
        this.add((Component)this.m_SaverEditor, "Center");
        this.validate();
        this.repaint();
    }

    private void setUpDatabase() {
        this.removeAll();
        JPanel db = new JPanel();
        db.setLayout(new GridLayout(7, 1));
        this.m_dbaseURLText = new JTextField(((DatabaseConverter)((Object)this.m_dsSaver.getSaver())).getUrl(), 50);
        JLabel dbaseURLLab = new JLabel(" Database URL:          ", 2);
        dbaseURLLab.setFont(new Font("Monospaced", 0, 12));
        this.m_userNameText = new JTextField(((DatabaseConverter)((Object)this.m_dsSaver.getSaver())).getUser(), 50);
        JLabel userNameLab = new JLabel(" Username:              ", 2);
        userNameLab.setFont(new Font("Monospaced", 0, 12));
        this.m_passwordText = new JPasswordField(50);
        JLabel passwordLab = new JLabel(" Password:              ", 2);
        passwordLab.setFont(new Font("Monospaced", 0, 12));
        this.m_tableText = new JTextField(((DatabaseSaver)this.m_dsSaver.getSaver()).getTableName(), 50);
        this.m_tableText.setEditable(!((DatabaseSaver)this.m_dsSaver.getSaver()).getRelationForTableName());
        JLabel tableLab = new JLabel(" Table Name:            ", 2);
        tableLab.setFont(new Font("Monospaced", 0, 12));
        this.m_tabBox = new JComboBox();
        this.m_tabBox.addItem(new Boolean(true));
        this.m_tabBox.addItem(new Boolean(false));
        if (!((DatabaseSaver)this.m_dsSaver.getSaver()).getRelationForTableName()) {
            this.m_tabBox.setSelectedIndex(1);
        } else {
            this.m_tabBox.setSelectedIndex(0);
        }
        this.m_tabBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SaverCustomizer.this.m_tableText.setEditable((Boolean)SaverCustomizer.this.m_tabBox.getSelectedItem() == false);
            }
        });
        JLabel tabLab = new JLabel(" Use relation name:     ", 2);
        tabLab.setFont(new Font("Monospaced", 0, 12));
        this.m_idBox = new JComboBox();
        this.m_idBox.addItem(new Boolean(true));
        this.m_idBox.addItem(new Boolean(false));
        if (!((DatabaseSaver)this.m_dsSaver.getSaver()).getAutoKeyGeneration()) {
            this.m_idBox.setSelectedIndex(1);
        } else {
            this.m_idBox.setSelectedIndex(0);
        }
        JLabel idLab = new JLabel(" Automatic primary key: ", 2);
        idLab.setFont(new Font("Monospaced", 0, 12));
        JPanel urlP = new JPanel();
        urlP.setLayout(new FlowLayout(0));
        urlP.add(dbaseURLLab);
        urlP.add(this.m_dbaseURLText);
        db.add(urlP);
        JPanel usernameP = new JPanel();
        usernameP.setLayout(new FlowLayout(0));
        usernameP.add(userNameLab);
        usernameP.add(this.m_userNameText);
        db.add(usernameP);
        JPanel passwordP = new JPanel();
        passwordP.setLayout(new FlowLayout(0));
        passwordP.add(passwordLab);
        passwordP.add(this.m_passwordText);
        db.add(passwordP);
        JPanel tabP = new JPanel();
        tabP.setLayout(new FlowLayout(0));
        tabP.add(tabLab);
        tabP.add(this.m_tabBox);
        db.add(tabP);
        JPanel tableP = new JPanel();
        tableP.setLayout(new FlowLayout(0));
        tableP.add(tableLab);
        tableP.add(this.m_tableText);
        db.add(tableP);
        JPanel keyP = new JPanel();
        keyP.setLayout(new FlowLayout(0));
        keyP.add(idLab);
        keyP.add(this.m_idBox);
        db.add(keyP);
        JPanel buttonsP = new JPanel();
        buttonsP.setLayout(new FlowLayout());
        JButton ok = new JButton("OK");
        buttonsP.add(ok);
        JButton cancel = new JButton("Cancel");
        buttonsP.add(cancel);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaver()).resetStructure();
                ((DatabaseConverter)((Object)SaverCustomizer.this.m_dsSaver.getSaver())).setUrl(SaverCustomizer.this.m_dbaseURLText.getText());
                ((DatabaseConverter)((Object)SaverCustomizer.this.m_dsSaver.getSaver())).setUser(SaverCustomizer.this.m_userNameText.getText());
                ((DatabaseConverter)((Object)SaverCustomizer.this.m_dsSaver.getSaver())).setPassword(new String(SaverCustomizer.this.m_passwordText.getPassword()));
                if (!((Boolean)SaverCustomizer.this.m_tabBox.getSelectedItem()).booleanValue()) {
                    ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaver()).setTableName(SaverCustomizer.this.m_tableText.getText());
                }
                ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaver()).setAutoKeyGeneration((Boolean)SaverCustomizer.this.m_idBox.getSelectedItem());
                ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaver()).setRelationForTableName((Boolean)SaverCustomizer.this.m_tabBox.getSelectedItem());
                if (SaverCustomizer.this.m_parentFrame != null) {
                    SaverCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (SaverCustomizer.this.m_parentFrame != null) {
                    SaverCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
        db.add(buttonsP);
        JPanel about = this.m_SaverEditor.getAboutPanel();
        if (about != null) {
            this.add((Component)about, "North");
        }
        this.add((Component)db, "South");
    }

    public void setUpFile() {
        this.removeAll();
        this.m_fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }

            public String getDescription() {
                return "Directory";
            }
        });
        this.m_fileChooser.setAcceptAllFileFilterUsed(false);
        try {
            if (!this.m_dsSaver.getSaver().retrieveDir().equals("")) {
                File tmp = new File(this.m_dsSaver.getSaver().retrieveDir());
                tmp = new File(tmp.getAbsolutePath());
                this.m_fileChooser.setCurrentDirectory(tmp);
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        try {
            this.m_prefixText = new JTextField(this.m_dsSaver.getSaver().filePrefix(), 25);
            this.m_prefixText.setToolTipText("Prefix for file name (or filename itself if relation name is not used)");
            final JLabel prefixLab = new JLabel(" Prefix for file name:", 2);
            this.m_relationNameForFilename = new JCheckBox("Relation name for filename");
            this.m_relationNameForFilename.setSelected(this.m_dsSaver.getRelationNameForFilename());
            this.m_relationNameForFilename.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SaverCustomizer.this.m_relationNameForFilename.isSelected()) {
                        prefixLab.setText("Prefix for file name");
                        SaverCustomizer.this.m_fileChooser.setApproveButtonText("Select directory and prefix");
                    } else {
                        prefixLab.setText("File name");
                        SaverCustomizer.this.m_fileChooser.setApproveButtonText("Select directory and filename");
                    }
                }
            });
            JPanel prefixP = new JPanel();
            prefixP.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            prefixP.setLayout(new BorderLayout());
            prefixP.add((Component)prefixLab, "West");
            prefixP.add((Component)this.m_prefixText, "Center");
            prefixP.add((Component)this.m_relationNameForFilename, "South");
            innerPanel.add((Component)prefixP, "South");
        }
        catch (Exception ex) {
            // empty catch block
        }
        JPanel about = this.m_SaverEditor.getAboutPanel();
        if (about != null) {
            innerPanel.add((Component)about, "North");
        }
        this.add((Component)innerPanel, "North");
        this.add((Component)this.m_fileChooser, "Center");
        this.m_relativeFilePath = new JCheckBox("Use relative file paths");
        this.m_relativeFilePath.setSelected(((FileSourcedConverter)((Object)this.m_dsSaver.getSaver())).getUseRelativePath());
        this.m_relativeFilePath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((FileSourcedConverter)((Object)SaverCustomizer.this.m_dsSaver.getSaver())).setUseRelativePath(SaverCustomizer.this.m_relativeFilePath.isSelected());
            }
        });
        JPanel holderPanel = new JPanel();
        holderPanel.setLayout(new FlowLayout());
        holderPanel.add(this.m_relativeFilePath);
        this.add((Component)holderPanel, "South");
    }

    public void setObject(Object object) {
        this.m_dsSaver = (Saver)object;
        this.m_SaverEditor.setTarget(this.m_dsSaver.getSaver());
        if (this.m_dsSaver.getSaver() instanceof DatabaseConverter) {
            this.setUpDatabase();
        } else if (this.m_dsSaver.getSaver() instanceof FileSourcedConverter) {
            this.setUpFile();
        } else {
            this.setUpOther();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

