/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;

public abstract class PotentialClassIgnorer
extends Filter
implements OptionHandler {
    private static final long serialVersionUID = 8625371119276845454L;
    protected boolean m_IgnoreClass = false;
    protected int m_ClassIndex = -1;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tUnsets the class index temporarily before the filter is\n\tapplied to the data.\n\t(default: no)", "unset-class-temporarily", 1, "-unset-class-temporarily"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setIgnoreClass(Utils.getFlag("unset-class-temporarily", stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getIgnoreClass()) {
            vector.add("-unset-class-temporarily");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        boolean bl = super.setInputFormat(instances);
        if (this.m_IgnoreClass) {
            this.m_ClassIndex = this.inputFormatPeek().classIndex();
            this.inputFormatPeek().setClassIndex(-1);
        }
        return bl;
    }

    public final Instances getOutputFormat() {
        if (this.m_IgnoreClass) {
            this.outputFormatPeek().setClassIndex(this.m_ClassIndex);
        }
        return super.getOutputFormat();
    }

    public String ignoreClassTipText() {
        return "The class index will be unset temporarily before the filter is applied.";
    }

    public void setIgnoreClass(boolean bl) {
        this.m_IgnoreClass = bl;
    }

    public boolean getIgnoreClass() {
        return this.m_IgnoreClass;
    }
}

