/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.swing.JComponent;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.JComponentWriter;

public class JPEGWriter
extends JComponentWriter {
    protected float m_Quality;
    protected Color m_Background;

    public JPEGWriter() {
    }

    public JPEGWriter(JComponent jComponent) {
        super(jComponent);
    }

    public JPEGWriter(JComponent jComponent, File file) {
        super(jComponent, file);
        this.m_Quality = 1.0f;
        this.m_Background = Color.WHITE;
    }

    public void initialize() {
        super.initialize();
        this.m_Quality = 1.0f;
        this.m_Background = Color.WHITE;
        this.setScalingEnabled(false);
    }

    public String getDescription() {
        return "JPEG-Image";
    }

    public String getExtension() {
        return ".jpg";
    }

    public Color getBackground() {
        return this.m_Background;
    }

    public void setBackground(Color color) {
        this.m_Background = color;
    }

    public float getQuality() {
        return this.m_Quality;
    }

    public void setQuality(float f) {
        this.m_Quality = f;
    }

    public void generateOutput() throws Exception {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.getFile()));
        BufferedImage bufferedImage = new BufferedImage(this.getComponent().getWidth(), this.getComponent().getHeight(), 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setPaintMode();
        graphics.setColor(this.getBackground());
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).scale(this.getXScale(), this.getYScale());
        }
        graphics.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
        this.getComponent().paint(graphics);
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
        JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
        jPEGEncodeParam.setQuality(this.getQuality(), false);
        jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
        jPEGImageEncoder.encode(bufferedImage);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("building TreeVisualizer...");
        TreeBuild treeBuild = new TreeBuild();
        PlaceNode2 placeNode2 = new PlaceNode2();
        Node node = treeBuild.create(new StringReader("digraph atree { top [label=\"the top\"] a [label=\"the first node\"] b [label=\"the second nodes\"] c [label=\"comes off of first\"] top->a top->b b->c }"));
        TreeVisualizer treeVisualizer = new TreeVisualizer(null, node, (NodePlace)placeNode2);
        treeVisualizer.setSize(800, 600);
        String string = System.getProperty("java.io.tmpdir") + File.separator + "test.jpg";
        System.out.println("outputting to '" + string + "'...");
        JPEGWriter.toOutput(new JPEGWriter(), treeVisualizer, new File(string));
        System.out.println("done!");
    }
}

