/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.generators;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public abstract class Generator
implements Serializable,
OptionHandler {
    private static final long serialVersionUID = 2412127331483792089L;
    protected boolean m_Debug = false;

    public abstract double getProbabilityOf(double var1);

    public abstract double getLogProbabilityOf(double var1);

    public abstract double generate();

    public Generator copy() {
        Generator result;
        try {
            result = (Generator)this.getClass().newInstance();
            result.setOptions(this.getOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static Generator forName(String generatorName, String[] options) throws Exception {
        return (Generator)Utils.forName(Generator.class, generatorName, options);
    }

    public abstract String globalInfo();

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tIf set, generator is run in debug mode and\n\tmay output additional info to the console", "D", 0, "-D"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag('D', options));
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getDebug()) {
            result.add("-D");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "If set to true, the generator might output debugging information in the console.";
    }
}

