/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.Stats;

public class AttributeStats
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 4434688832743939380L;
    public int intCount = 0;
    public int realCount = 0;
    public int missingCount = 0;
    public int distinctCount = 0;
    public int uniqueCount = 0;
    public int totalCount = 0;
    public Stats numericStats;
    public int[] nominalCounts;
    public double[] nominalWeights;

    protected void addDistinct(double value, int count, double weight) {
        if (count > 0) {
            if (count == 1) {
                ++this.uniqueCount;
            }
            if (Utils.eq(value, (int)value)) {
                this.intCount += count;
            } else {
                this.realCount += count;
            }
            if (this.nominalCounts != null) {
                this.nominalCounts[(int)value] = count;
                this.nominalWeights[(int)value] = weight;
            }
            if (this.numericStats != null) {
                this.numericStats.add(value, weight);
                this.numericStats.calculateDerived();
            }
        }
        ++this.distinctCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Utils.padLeft("Type", 4)).append(Utils.padLeft("Nom", 5));
        sb.append(Utils.padLeft("Int", 5)).append(Utils.padLeft("Real", 5));
        sb.append(Utils.padLeft("Missing", 12));
        sb.append(Utils.padLeft("Unique", 12));
        sb.append(Utils.padLeft("Dist", 6));
        if (this.nominalCounts != null) {
            sb.append(' ');
            for (int i = 0; i < this.nominalCounts.length; ++i) {
                sb.append(Utils.padLeft("C[" + i + "]", 5));
            }
        }
        sb.append('\n');
        long percent = Math.round(100.0 * (double)this.intCount / (double)this.totalCount);
        if (this.nominalCounts != null) {
            sb.append(Utils.padLeft("Nom", 4)).append(' ');
            sb.append(Utils.padLeft("" + percent, 3)).append("% ");
            sb.append(Utils.padLeft("0", 3)).append("% ");
        } else {
            sb.append(Utils.padLeft("Num", 4)).append(' ');
            sb.append(Utils.padLeft("0", 3)).append("% ");
            sb.append(Utils.padLeft("" + percent, 3)).append("% ");
        }
        percent = Math.round(100.0 * (double)this.realCount / (double)this.totalCount);
        sb.append(Utils.padLeft("" + percent, 3)).append("% ");
        sb.append(Utils.padLeft("" + this.missingCount, 5)).append(" /");
        percent = Math.round(100.0 * (double)this.missingCount / (double)this.totalCount);
        sb.append(Utils.padLeft("" + percent, 3)).append("% ");
        sb.append(Utils.padLeft("" + this.uniqueCount, 5)).append(" /");
        percent = Math.round(100.0 * (double)this.uniqueCount / (double)this.totalCount);
        sb.append(Utils.padLeft("" + percent, 3)).append("% ");
        sb.append(Utils.padLeft("" + this.distinctCount, 5)).append(' ');
        if (this.nominalCounts != null) {
            for (int i = 0; i < this.nominalCounts.length; ++i) {
                sb.append(Utils.padLeft("" + this.nominalCounts[i], 5));
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5296 $");
    }
}

