/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.kdtrees;

import java.io.Serializable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class KDTreeNode
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -3660396067582792648L;
    public int m_NodeNumber;
    public KDTreeNode m_Left = null;
    public KDTreeNode m_Right = null;
    public double m_SplitValue;
    public int m_SplitDim;
    public double[][] m_NodeRanges;
    public double[][] m_NodesRectBounds;
    public int m_Start = 0;
    public int m_End = 0;

    public KDTreeNode() {
    }

    public KDTreeNode(int nodeNum, int startidx, int endidx, double[][] nodeRanges) {
        this.m_NodeNumber = nodeNum;
        this.m_Start = startidx;
        this.m_End = endidx;
        this.m_NodeRanges = nodeRanges;
    }

    public KDTreeNode(int nodeNum, int startidx, int endidx, double[][] nodeRanges, double[][] rectBounds) {
        this.m_NodeNumber = nodeNum;
        this.m_Start = startidx;
        this.m_End = endidx;
        this.m_NodeRanges = nodeRanges;
        this.m_NodesRectBounds = rectBounds;
    }

    public int getSplitDim() {
        return this.m_SplitDim;
    }

    public double getSplitValue() {
        return this.m_SplitValue;
    }

    public boolean isALeaf() {
        return this.m_Left == null;
    }

    public int numInstances() {
        return this.m_End - this.m_Start + 1;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }
}

