/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class OLM
extends AbstractClassifier
implements OptionHandler,
TechnicalInformationHandler {
    private static final long serialVersionUID = -381974207649598344L;
    protected int printR;
    protected int numExamples;
    public static final int RESOLUTION_NONE = 3;
    public static final int RESOLUTION_AVERAGE = 2;
    public static final int RESOLUTION_RANDOM = 1;
    public static final int RESOLUTION_CONSERVATIVE = 0;
    public static final Tag[] TAGS_RESOLUTION = new Tag[]{new Tag(3, "No conflict resolution"), new Tag(2, "Resolution using average"), new Tag(1, "Random resolution"), new Tag(0, "Conservative resolution")};
    protected int m_resolutionMode = 0;
    public static final int CLASSIFICATION_CONSERVATIVE = 1;
    public static final int CLASSIFICATION_NEARESTNEIGHBOUR = 0;
    public static final Tag[] TAGS_CLASSIFICATION = new Tag[]{new Tag(0, "Nearest neighbour classification"), new Tag(1, "Conservative classification")};
    protected int m_classificationMode = 1;
    protected int upperBaseLimit = -1;
    protected int randSeed = 0;
    protected Random rand = new Random(0L);
    protected boolean print_msg = false;
    private OLMRules olmrules;

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(1);
        return result;
    }

    public String globalInfo() {
        return "This class is an implementation of the Ordinal Learning Method (OLM).\nFurther information regarding the algorithm and variants can be found in:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Arie Ben-David");
        result.setValue(TechnicalInformation.Field.YEAR, "1992");
        result.setValue(TechnicalInformation.Field.TITLE, "Automatic Generation of Symbolic Multiattribute Ordinal Knowledge-Based DSSs: methodology and Applications");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Decision Sciences");
        result.setValue(TechnicalInformation.Field.PAGES, "1357-1372");
        result.setValue(TechnicalInformation.Field.VOLUME, "23");
        return result;
    }

    public double classifyInstance(Instance inst) {
        return this.olmrules.classify(inst);
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tThe resolution mode. Valid values are:\n\t0 for conservative resolution, 1 for random resolution,\t2 for average, and 3 for no resolution. (default 0).", "R", 1, "-R <integer>"));
        newVector.addElement(new Option("\tThe classification mode. Valid values are:\n\t0 for conservative classification, 1 for nearest neighbour classification. (default 0).", "C", 1, "-C <integer>"));
        newVector.addElement(new Option("\tSSet maximum size of rule base\n\t(default: -U <number of examples>)", "U", 1, "-U <size>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String upperBase;
        String classificationMode;
        String resolutionMode = Utils.getOption('R', options);
        if (resolutionMode.length() > 0) {
            this.setResolutionMode(new SelectedTag(Integer.parseInt(resolutionMode), TAGS_RESOLUTION));
        }
        if ((classificationMode = Utils.getOption('C', options)).length() > 0) {
            this.setClassificationMode(new SelectedTag(Integer.parseInt(classificationMode), TAGS_CLASSIFICATION));
        }
        if ((upperBase = Utils.getOption('U', options)).length() != 0) {
            this.upperBaseLimit = Integer.parseInt(upperBase);
        }
    }

    public String[] getOptions() {
        String[] options = new String[6];
        int current = 0;
        if (this.upperBaseLimit == -1) {
            this.upperBaseLimit = this.numExamples;
        }
        options[current++] = "-R";
        options[current++] = "" + this.m_resolutionMode;
        options[current++] = "-C";
        options[current++] = "" + this.m_classificationMode;
        options[current++] = "-U";
        options[current++] = "" + this.upperBaseLimit;
        return options;
    }

    public String resolutionModeTipText() {
        return "The resolution mode to use.";
    }

    public void setResolutionMode(SelectedTag newMethod) {
        if (newMethod.getTags() == TAGS_RESOLUTION) {
            this.m_resolutionMode = newMethod.getSelectedTag().getID();
        }
    }

    public SelectedTag getResolutionMode() {
        return new SelectedTag(this.m_resolutionMode, TAGS_RESOLUTION);
    }

    public void setClassificationMode(SelectedTag newMethod) {
        this.m_classificationMode = newMethod.getSelectedTag().getID();
    }

    public SelectedTag getClassificationMode() {
        return new SelectedTag(this.m_classificationMode, TAGS_CLASSIFICATION);
    }

    public String classificationModeTipText() {
        return "The classification mode to use.";
    }

    public String ruleSizeTipText() {
        return "Set the rule base size\n0 - unlimited\n";
    }

    public int getRuleSize() {
        return this.upperBaseLimit;
    }

    public void setRuleSize(int s) {
        this.upperBaseLimit = s;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        this.numExamples = data.numInstances();
        Enumeration e = data.enumerateInstances();
        this.rand = new Random(0L);
        if (this.print_msg) {
            System.out.println("Resolution mode: " + this.m_resolutionMode);
        }
        if (this.print_msg) {
            System.out.println("Classification: " + this.m_classificationMode);
        }
        if (this.print_msg) {
            System.out.println("Rule size: " + this.upperBaseLimit);
        }
        this.olmrules = new OLMRules();
        int i = 0;
        if (this.print_msg) {
            System.out.println("Printing Rule Process");
        }
        while (e.hasMoreElements()) {
            Instance ins = (Instance)e.nextElement();
            if (this.print_msg) {
                System.out.println("Trying to add (" + ins.toString() + ") Rule");
            }
            this.olmrules.addRule(ins);
            if (this.print_msg) {
                System.out.println("Result:");
            }
            if (this.print_msg) {
                this.olmrules.printRules();
            }
            ++i;
        }
    }

    public String toString() {
        return "OLM";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5928 $");
    }

    public static void main(String[] args) {
        OLM.runClassifier(new OLM(), args);
    }

    private class OLMRules
    implements Serializable {
        private Vector rules = new Vector();

        public int distance(Instance inst1, Instance inst2) {
            double[] values1 = inst1.toDoubleArray();
            double[] values2 = inst2.toDoubleArray();
            int classindex = inst1.classIndex();
            int numAtt = inst1.numAttributes();
            int dist = 0;
            for (int i = 0; i < numAtt; ++i) {
                if (i == classindex) continue;
                dist = (int)((double)dist + Math.abs(values1[i] - values2[i]));
            }
            return dist;
        }

        public Instance averageRule(Instance inst1, Instance inst2) {
            Instance inst = inst1;
            double[] values1 = inst1.toDoubleArray();
            double[] values2 = inst2.toDoubleArray();
            int classindex = inst1.classIndex();
            int numAtt = inst1.numAttributes();
            for (int i = 0; i < numAtt; ++i) {
                inst.setValue(i, (double)Math.round((values1[i] + values2[i]) / 2.0));
            }
            return inst;
        }

        public void printRules() {
            for (int i = 0; i < this.rules.size(); ++i) {
                Instance inst = (Instance)this.rules.elementAt(i);
                System.out.print(i + ": ");
                System.out.println(inst.toString());
            }
        }

        private boolean isGreaterInput(Instance inst1, Instance inst2) {
            double[] values1 = inst1.toDoubleArray();
            double[] values2 = inst2.toDoubleArray();
            int classindex = inst1.classIndex();
            int numAtt = inst1.numAttributes();
            for (int i = 0; i < numAtt; ++i) {
                if (i == classindex || !(values1[i] < values2[i])) continue;
                return false;
            }
            return true;
        }

        private boolean isEqualInput(Instance inst1, Instance inst2) {
            double[] values1 = inst1.toDoubleArray();
            double[] values2 = inst2.toDoubleArray();
            int classindex = inst1.classIndex();
            int numAtt = inst1.numAttributes();
            for (int i = 0; i < numAtt; ++i) {
                if (i == classindex || values1[i] == values2[i]) continue;
                return false;
            }
            return true;
        }

        private boolean isGreaterOutput(Instance inst1, Instance inst2) {
            return inst1.toDoubleArray()[inst1.classIndex()] > inst2.toDoubleArray()[inst2.classIndex()];
        }

        private boolean isEqualOutput(Instance inst1, Instance inst2) {
            return inst1.toDoubleArray()[inst1.classIndex()] == inst2.toDoubleArray()[inst2.classIndex()];
        }

        private void fillMissing(Instance inst) {
        }

        public void addRule(Instance inst) {
            int i;
            boolean addr = true;
            boolean b = false;
            int classindex = inst.classIndex();
            this.fillMissing(inst);
            for (i = 0; i < this.rules.size(); ++i) {
                b = false;
                if (this.isEqualOutput(inst, (Instance)this.rules.elementAt(i))) {
                    if (this.isGreaterInput(inst, (Instance)this.rules.elementAt(i))) {
                        addr = false;
                        if (!OLM.this.print_msg) continue;
                        System.out.println(inst.toString() + " is (1) redundant wrt " + ((Instance)this.rules.elementAt(i)).toString());
                        continue;
                    }
                    if (this.isGreaterInput((Instance)this.rules.elementAt(i), inst)) {
                        if (OLM.this.print_msg) {
                            System.out.println(((Instance)this.rules.elementAt(i)).toString() + " is (2) redundant wrt " + inst.toString());
                        }
                        this.rules.removeElementAt(i);
                        --i;
                        continue;
                    }
                }
                if (this.isGreaterInput((Instance)this.rules.elementAt(i), inst) && !this.isGreaterOutput((Instance)this.rules.elementAt(i), inst)) {
                    if (OLM.this.m_resolutionMode == 0) {
                        addr = false;
                    }
                    if (OLM.this.m_resolutionMode == 1) {
                        if (OLM.this.rand.nextBoolean()) {
                            if (!addr) {
                                // empty if block
                            }
                            addr = true;
                            this.rules.removeElementAt(i);
                            --i;
                        } else {
                            addr = false;
                        }
                    }
                    if (OLM.this.m_resolutionMode == 3) {
                        addr = false;
                    }
                    if (OLM.this.m_resolutionMode != 2) continue;
                    if (OLM.this.print_msg) {
                        System.out.print(inst.toString() + " - " + ((Instance)this.rules.elementAt(i)).toString());
                    }
                    inst = this.averageRule(inst, (Instance)this.rules.elementAt(i));
                    System.out.println(" : Average : " + inst.toString());
                    this.rules.removeElementAt(i);
                    addr = true;
                    i = 0;
                    continue;
                }
                if (this.isGreaterInput(inst, (Instance)this.rules.elementAt(i)) && !this.isGreaterOutput(inst, (Instance)this.rules.elementAt(i))) {
                    if (OLM.this.m_resolutionMode == 0) {
                        if (OLM.this.print_msg) {
                            System.out.println("Discard rule " + ((Instance)this.rules.elementAt(i)).toString());
                        }
                        b = true;
                        this.rules.removeElementAt(i);
                        --i;
                    }
                    if (OLM.this.m_resolutionMode == 1) {
                        if (OLM.this.rand.nextBoolean()) {
                            if (!addr) {
                                // empty if block
                            }
                            addr = true;
                            this.rules.removeElementAt(i);
                            --i;
                        } else {
                            addr = false;
                        }
                    }
                    if (OLM.this.m_resolutionMode == 3) {
                        addr = false;
                    }
                    if (OLM.this.m_resolutionMode != 2) continue;
                    if (OLM.this.print_msg) {
                        System.out.print(inst.toString() + " - " + ((Instance)this.rules.elementAt(i)).toString());
                    }
                    inst = this.averageRule(inst, (Instance)this.rules.elementAt(i));
                    if (OLM.this.print_msg) {
                        System.out.println(" : Average : " + inst.toString());
                    }
                    this.rules.removeElementAt(i);
                    addr = true;
                    i = 0;
                    continue;
                }
                if (!this.isEqualInput(inst, (Instance)this.rules.elementAt(i))) continue;
                if (this.isGreaterOutput(inst, (Instance)this.rules.elementAt(i))) {
                    if (OLM.this.m_resolutionMode == 0) {
                        addr = false;
                    }
                    if (OLM.this.m_resolutionMode == 1) {
                        if (OLM.this.rand.nextBoolean()) {
                            if (!addr) {
                                // empty if block
                            }
                            addr = true;
                            this.rules.removeElementAt(i);
                            --i;
                        } else {
                            addr = false;
                        }
                    }
                    if (OLM.this.m_resolutionMode == 3) {
                        addr = false;
                    }
                    if (OLM.this.m_resolutionMode != 2) continue;
                    if (OLM.this.print_msg) {
                        System.out.print(inst.toString() + " - " + ((Instance)this.rules.elementAt(i)).toString());
                    }
                    inst = this.averageRule(inst, (Instance)this.rules.elementAt(i));
                    if (OLM.this.print_msg) {
                        System.out.println(" : 2Average : " + inst.toString());
                    }
                    this.rules.removeElementAt(i);
                    addr = true;
                    i = 0;
                    continue;
                }
                if (!this.isGreaterOutput((Instance)this.rules.elementAt(i), inst)) continue;
                if (OLM.this.m_resolutionMode == 0) {
                    this.rules.removeElementAt(i);
                    --i;
                }
                if (OLM.this.m_resolutionMode == 1) {
                    if (OLM.this.rand.nextBoolean()) {
                        if (!addr) {
                            // empty if block
                        }
                        addr = true;
                        this.rules.removeElementAt(i);
                        --i;
                    } else {
                        addr = false;
                    }
                }
                if (OLM.this.m_resolutionMode == 3) {
                    addr = false;
                }
                if (OLM.this.m_resolutionMode != 2) continue;
                if (OLM.this.print_msg) {
                    System.out.print(inst.toString() + " - " + ((Instance)this.rules.elementAt(i)).toString());
                }
                inst = this.averageRule(inst, (Instance)this.rules.elementAt(i));
                if (OLM.this.print_msg) {
                    System.out.println(" : Average : " + inst.toString());
                }
                this.rules.removeElementAt(i);
                addr = true;
                i = 0;
            }
            if (b) {
                System.out.println("broke out of loop totally!!");
            }
            double output = inst.toDoubleArray()[classindex];
            if (addr && (OLM.this.upperBaseLimit <= 0 || OLM.this.upperBaseLimit > this.rules.size())) {
                for (i = 0; i < this.rules.size() && ((Instance)this.rules.elementAt(i)).toDoubleArray()[classindex] > output; ++i) {
                }
                if (i == this.rules.size()) {
                    this.rules.addElement(inst);
                } else if (i == 0) {
                    this.rules.insertElementAt(inst, 0);
                } else {
                    this.rules.insertElementAt(inst, i);
                }
            }
        }

        public double classify(Instance inst) {
            this.fillMissing(inst);
            if (OLM.this.m_classificationMode == 1) {
                for (int i = 0; i < this.rules.size(); ++i) {
                    Instance tInst = (Instance)this.rules.elementAt(i);
                    if (!this.isGreaterInput(inst, tInst)) continue;
                    return tInst.toDoubleArray()[inst.classIndex()];
                }
                return ((Instance)this.rules.lastElement()).toDoubleArray()[inst.classIndex()];
            }
            int cDist = -1;
            int elem = -1;
            if (OLM.this.m_classificationMode == 0) {
                for (int i = 0; i < this.rules.size(); ++i) {
                    Instance tInst = (Instance)this.rules.elementAt(i);
                    if (cDist == -1 || this.distance(inst, tInst) < cDist) {
                        cDist = this.distance(inst, tInst);
                        elem = i;
                    }
                    if (!OLM.this.print_msg) continue;
                    System.out.println(((Instance)this.rules.elementAt(i)).toString() + " - " + inst.toString() + ": Distance is " + this.distance(inst, tInst));
                }
                if (OLM.this.print_msg) {
                    System.out.println(((Instance)this.rules.elementAt(elem)).toString() + " is closest to " + inst.toString());
                }
                return ((Instance)this.rules.elementAt(elem)).toDoubleArray()[inst.classIndex()];
            }
            return 0.0;
        }
    }
}

