/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import weka.associations.Item;
import weka.core.Attribute;
import weka.core.Utils;

public class NumericItem
extends Item
implements Serializable {
    private static final long serialVersionUID = -7869433770765864800L;
    protected double m_splitPoint;
    protected Comparison m_comparison;

    public NumericItem(Attribute att, double splitPoint, Comparison comp) throws Exception {
        super(att);
        if (!att.isNumeric()) {
            throw new Exception("NumericItem must be constructed using a numeric attribute");
        }
        this.m_comparison = comp;
        this.m_splitPoint = splitPoint;
    }

    public double getSplitPoint() {
        return this.m_splitPoint;
    }

    public Comparison getComparison() {
        return this.m_comparison;
    }

    public String getItemValueAsString() {
        return Utils.doubleToString(this.m_splitPoint, 3);
    }

    public String getComparisonAsString() {
        String result = null;
        switch (this.m_comparison) {
            case EQUAL: {
                result = "=";
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                result = "<=";
                break;
            }
            case GREATER_THAN: {
                result = ">";
            }
        }
        return result;
    }

    public String toString(boolean freq) {
        StringBuffer result = new StringBuffer();
        result.append(this.m_attribute.name() + " ");
        switch (this.m_comparison) {
            case EQUAL: {
                result.append("=");
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                result.append("<=");
                break;
            }
            case GREATER_THAN: {
                result.append(">");
            }
        }
        result.append(" " + Utils.doubleToString(this.m_splitPoint, 4));
        if (freq) {
            result.append(":" + this.m_frequency);
        }
        return result.toString();
    }

    public boolean equals(Object compareTo) {
        if (!(compareTo instanceof NumericItem)) {
            return false;
        }
        NumericItem b = (NumericItem)compareTo;
        return this.m_attribute.equals(b.getAttribute()) && this.m_comparison == b.getComparison() && new Double(this.m_splitPoint).equals(new Double(b.getSplitPoint()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Comparison {
        NONE,
        EQUAL,
        LESS_THAN_OR_EQUAL_TO,
        GREATER_THAN;

    }
}

