/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.gui.visualize.PlotData2D;

public abstract class AbstractPlotInstances
implements Serializable,
OptionHandler {
    private static final long serialVersionUID = 2375155184845160908L;
    protected Instances m_Instances;
    protected Instances m_PlotInstances;
    protected boolean m_FinishUpCalled;

    public AbstractPlotInstances() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Instances = null;
        this.m_PlotInstances = null;
        this.m_FinishUpCalled = false;
    }

    public Enumeration listOptions() {
        return new Vector().elements();
    }

    public void setOptions(String[] options) throws Exception {
    }

    public String[] getOptions() {
        return new String[0];
    }

    protected abstract void determineFormat();

    public void setInstances(Instances value) {
        this.m_Instances = value;
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    protected void check() {
        if (this.m_Instances == null) {
            throw new IllegalStateException("No instances set!");
        }
    }

    public void setUp() {
        this.m_FinishUpCalled = false;
        this.check();
        this.determineFormat();
    }

    protected void finishUp() {
        this.m_FinishUpCalled = true;
    }

    public boolean canPlot(boolean setup) {
        try {
            if (setup) {
                this.setUp();
            }
            return this.getPlotInstances().numInstances() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Instances getPlotInstances() {
        if (!this.m_FinishUpCalled) {
            this.finishUp();
        }
        return this.m_PlotInstances;
    }

    protected abstract PlotData2D createPlotData(String var1) throws Exception;

    public PlotData2D getPlotData(String name) throws Exception {
        if (!this.m_FinishUpCalled) {
            this.finishUp();
        }
        return this.createPlotData(name);
    }

    public void cleanUp() {
        this.m_Instances = null;
        this.m_PlotInstances = null;
        this.m_FinishUpCalled = false;
    }
}

