/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JFrame;
import weka.core.Instances;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataVisualizer;
import weka.gui.visualize.MatrixPanel;

public class ScatterPlotMatrix
extends DataVisualizer {
    private static final long serialVersionUID = -657856527563507491L;
    protected MatrixPanel m_matrixPanel;

    public ScatterPlotMatrix() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!ge.isHeadless()) {
            this.appearanceFinal();
        }
    }

    @Override
    public String globalInfo() {
        return "Visualize incoming data/training/test sets in a scatter plot matrix.";
    }

    @Override
    protected void appearanceDesign() {
        this.m_matrixPanel = null;
        this.removeAll();
        this.m_visual = new BeanVisual("ScatterPlotMatrix", "weka/gui/beans/icons/ScatterPlotMatrix.gif", "weka/gui/beans/icons/ScatterPlotMatrix_animated.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    @Override
    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setUpFinal();
    }

    @Override
    protected void setUpFinal() {
        if (this.m_matrixPanel == null) {
            this.m_matrixPanel = new MatrixPanel();
        }
        this.add((Component)this.m_matrixPanel, "Center");
    }

    @Override
    public void setInstances(Instances inst) throws Exception {
        if (this.m_design) {
            throw new Exception("This method is not to be used during design time. It is meant to be used if this bean is being used programatically as as stand alone component.");
        }
        this.m_visualizeDataSet = inst;
        this.m_matrixPanel.setInstances(this.m_visualizeDataSet);
    }

    @Override
    public void performRequest(String request) {
        block5: {
            if (request.compareTo("Show plot") == 0) {
                try {
                    if (!this.m_framePoppedUp) {
                        this.m_framePoppedUp = true;
                        MatrixPanel vis = new MatrixPanel();
                        vis.setInstances(this.m_visualizeDataSet);
                        final JFrame jf = new JFrame("Visualize");
                        jf.setSize(800, 600);
                        jf.getContentPane().setLayout(new BorderLayout());
                        jf.getContentPane().add((Component)vis, "Center");
                        jf.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                jf.dispose();
                                ScatterPlotMatrix.this.m_framePoppedUp = false;
                            }
                        });
                        jf.setVisible(true);
                        this.m_popupFrame = jf;
                        break block5;
                    }
                    this.m_popupFrame.toFront();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.m_framePoppedUp = false;
                }
            } else {
                throw new IllegalArgumentException(request + " not supported (ScatterPlotMatrix)");
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.err.println("Usage: ScatterPlotMatrix <dataset>");
                System.exit(1);
            }
            BufferedReader r = new BufferedReader(new FileReader(args[0]));
            Instances inst = new Instances(r);
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            ScatterPlotMatrix as = new ScatterPlotMatrix();
            as.setInstances(inst);
            jf.getContentPane().add((Component)as, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

