/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.SimpleStreamFilter;

public class RenameAttribute
extends SimpleStreamFilter {
    private static final long serialVersionUID = 4216491776378279596L;
    protected String m_Find = "([\\s\\S]+)";
    protected String m_Replace = "$0";
    protected Range m_AttributeIndices = new Range("first-last");
    protected boolean m_ReplaceAll = false;

    public String globalInfo() {
        return "This filter is used for renaming attribute names.\nRegular expressions can be used in the matching and replacing.\nSee Javadoc of java.util.regex.Pattern class for more information:\nhttp://java.sun.com/javase/6/docs/api/java/util/regex/Pattern.html";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe regular expression that the attribute names must match.\n\t(default: ([\\s\\S]+))", "find", 1, "-find <regexp>"));
        result.addElement(new Option("\tThe string to replace the regular expression of matching attributes with.\n\tCannot be used in conjunction with '-remove'.\n\t(default: $0)", "replace", 1, "-replace <string>"));
        result.addElement(new Option("\tIn case the matching string needs to be removed instead of replaced.\n\tCannot be used in conjunction with '-replace <string>'.\n\t(default: off)", "remove", 0, "-remove"));
        result.addElement(new Option("\tReplaces all occurrences instead of just the first.\n\t(default: only first occurrence)", "all", 0, "-all"));
        result.addElement(new Option("\tThe attribute range to work on.\nThis is a comma separated list of attribute indices, with \"first\" and \"last\" valid values.\n\tSpecify an inclusive range with \"-\".\n\tE.g: \"first-3,5,6-10,last\".\n\t(default: first-last)", "R", 1, "-R <range>"));
        result.addElement(new Option("\tInverts the attribute selection range.\n\t(default: off)", "V", 0, "-V"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption("find", options);
        if (tmpStr.length() != 0) {
            this.setFind(tmpStr);
        } else {
            this.setFind("([\\s\\S]+)");
        }
        if (Utils.getFlag("remove", options)) {
            this.setReplace("");
        } else {
            tmpStr = Utils.getOption("replace", options);
            if (tmpStr.length() > 0) {
                this.setReplace(tmpStr);
            } else {
                this.setReplace("$0");
            }
        }
        this.setReplaceAll(Utils.getFlag("all", options));
        tmpStr = Utils.getOption("R", options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices("first-last");
        }
        this.setInvertSelection(Utils.getFlag("V", options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>(Arrays.asList(super.getOptions()));
        result.add("-find");
        result.add(this.getFind());
        if (this.getReplace().length() > 0) {
            result.add("-replace");
            result.add(this.getReplace());
        } else {
            result.add("-remove");
        }
        if (this.getReplaceAll()) {
            result.add("-all");
        }
        result.add("-R");
        result.add(this.getAttributeIndices());
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setFind(String value) {
        this.m_Find = value;
    }

    public String getFind() {
        return this.m_Find;
    }

    public String findTipText() {
        return "The regular expression that the attribute names must match.";
    }

    public void setReplace(String value) {
        this.m_Replace = value;
    }

    public String getReplace() {
        return this.m_Replace;
    }

    public String replaceTipText() {
        return "The regular expression to use for replacing the matching attribute names with.";
    }

    public void setReplaceAll(boolean value) {
        this.m_ReplaceAll = value;
    }

    public boolean getReplaceAll() {
        return this.m_ReplaceAll;
    }

    public String replaceAllTipText() {
        return "If set to true, then all occurrences of the match will be replaced; otherwise only the first.";
    }

    public void setAttributeIndices(String value) {
        this.m_AttributeIndices.setRanges(value);
    }

    public String getAttributeIndices() {
        return this.m_AttributeIndices.getRanges();
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on; this is a comma separated list of attribute indices, with \"first\" and \"last\" valid values; specify an inclusive range with \"-\"; eg: \"first-3,5,6-10,last\".";
    }

    public void setInvertSelection(boolean value) {
        this.m_AttributeIndices.setInvert(value);
    }

    public boolean getInvertSelection() {
        return this.m_AttributeIndices.getInvert();
    }

    public String invertSelectionTipText() {
        return "If set to true, the selection will be inverted; eg: the attribute indices '2-4' then mean everything apart from '2-4'.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_AttributeIndices.setUpper(inputFormat.numAttributes() - 1);
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            Attribute att = inputFormat.attribute(i);
            if (this.m_AttributeIndices.isInRange(i)) {
                if (this.m_ReplaceAll) {
                    atts.add(att.copy(att.name().replaceAll(this.m_Find, this.m_Replace)));
                    continue;
                }
                atts.add(att.copy(att.name().replaceFirst(this.m_Find, this.m_Replace)));
                continue;
            }
            atts.add((Attribute)att.copy());
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        result.setClassIndex(inputFormat.classIndex());
        return result;
    }

    protected Instance process(Instance instance) throws Exception {
        return (Instance)instance.copy();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 7503 $");
    }

    public static void main(String[] args) {
        RenameAttribute.runFilter(new RenameAttribute(), args);
    }
}

