/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.AbstractSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.FileSourcedConverter;

public abstract class AbstractFileSaver
extends AbstractSaver
implements OptionHandler,
FileSourcedConverter,
EnvironmentHandler {
    private File m_outputFile;
    private transient BufferedWriter m_writer;
    private String FILE_EXTENSION;
    private final String FILE_EXTENSION_COMPRESSED = ".gz";
    private String m_prefix;
    private String m_dir;
    protected int m_incrementalCounter;
    protected boolean m_useRelativePath = false;
    protected transient Environment m_env;

    public void resetOptions() {
        super.resetOptions();
        this.m_outputFile = null;
        this.m_writer = null;
        this.m_prefix = "";
        this.m_dir = "";
        this.m_incrementalCounter = 0;
    }

    public BufferedWriter getWriter() {
        return this.m_writer;
    }

    public void resetWriter() {
        this.m_writer = null;
    }

    public String getFileExtension() {
        return this.FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{this.getFileExtension(), ".gz"};
    }

    protected void setFileExtension(String ext) {
        this.FILE_EXTENSION = ext;
    }

    public File retrieveFile() {
        return this.m_outputFile;
    }

    public void setFile(File outputFile) throws IOException {
        this.m_outputFile = outputFile;
        this.setDestination(outputFile);
    }

    public void setFilePrefix(String prefix) {
        this.m_prefix = prefix;
    }

    public String filePrefix() {
        return this.m_prefix;
    }

    public void setDir(String dir) {
        this.m_dir = dir;
    }

    public String retrieveDir() {
        return this.m_dir;
    }

    public void setEnvironment(Environment env) {
        this.m_env = env;
        if (this.m_outputFile != null) {
            try {
                this.setFile(this.m_outputFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tThe input file", "i", 1, "-i <the input file>"));
        newVector.addElement(new Option("\tThe output file", "o", 1, "-o <the output file>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String outputString = Utils.getOption('o', options);
        String inputString = Utils.getOption('i', options);
        ArffLoader loader = new ArffLoader();
        this.resetOptions();
        if (inputString.length() != 0) {
            try {
                File input = new File(inputString);
                loader.setFile(input);
                this.setInstances(loader.getDataSet());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException("No data set loaded. Data set has to be in ARFF format.");
            }
        }
        if (outputString.length() != 0) {
            boolean validExt = false;
            for (String ext : this.getFileExtensions()) {
                if (!outputString.endsWith(ext)) continue;
                validExt = true;
                break;
            }
            if (!validExt) {
                outputString = outputString.lastIndexOf(46) != -1 ? outputString.substring(0, outputString.lastIndexOf(46)) + this.FILE_EXTENSION : outputString + this.FILE_EXTENSION;
            }
            try {
                File output = new File(outputString);
                this.setFile(output);
            }
            catch (Exception ex) {
                throw new IOException("Cannot create output file (Reason: " + ex.toString() + "). Standard out is used.");
            }
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.m_outputFile != null) {
            result.add("-o");
            result.add("" + this.m_outputFile);
        }
        if (this.getInstances() != null) {
            result.add("-i");
            result.add("" + this.getInstances().relationName());
        }
        return result.toArray(new String[result.size()]);
    }

    public void cancel() {
        if (this.getWriteMode() == 2) {
            if (this.m_outputFile != null && this.m_outputFile.exists() && this.m_outputFile.delete()) {
                System.out.println("File deleted.");
            }
            this.resetOptions();
        }
    }

    public void setDestination(File file) throws IOException {
        boolean success = false;
        String tempOut = file.getPath();
        try {
            if (this.m_env == null) {
                this.m_env = Environment.getSystemWide();
            }
            tempOut = this.m_env.substitute(tempOut);
        }
        catch (Exception ex) {
            // empty catch block
        }
        file = new File(tempOut);
        String out = file.getAbsolutePath();
        if (this.m_outputFile != null) {
            try {
                block19: {
                    try {
                        if (file.exists() && !file.delete()) {
                            throw new IOException("File already exists.");
                        }
                        if (out.lastIndexOf(File.separatorChar) == -1) {
                            success = file.createNewFile();
                        } else {
                            String outPath = out.substring(0, out.lastIndexOf(File.separatorChar));
                            File dir = new File(outPath);
                            if (dir.exists()) {
                                success = file.createNewFile();
                            } else {
                                dir.mkdirs();
                                success = file.createNewFile();
                            }
                        }
                        if (!success) break block19;
                        if (this.m_useRelativePath) {
                            try {
                                this.m_outputFile = Utils.convertToRelativePath(file);
                            }
                            catch (Exception e) {
                                this.m_outputFile = file;
                            }
                        } else {
                            this.m_outputFile = file;
                        }
                        this.setDestination(new FileOutputStream(this.m_outputFile));
                    }
                    catch (Exception ex) {
                        throw new IOException("Cannot create a new output file (Reason: " + ex.toString() + "). Standard out is used.");
                    }
                }
                Object var8_10 = null;
                if (!success) {
                    System.err.println("Cannot create a new output file. Standard out is used.");
                    this.m_outputFile = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (!success) {
                    System.err.println("Cannot create a new output file. Standard out is used.");
                    this.m_outputFile = null;
                }
                throw throwable;
            }
        }
    }

    public void setDestination(OutputStream output) throws IOException {
        this.m_writer = new BufferedWriter(new OutputStreamWriter(output));
    }

    public void setDirAndPrefix(String relationName, String add) {
        try {
            if (this.m_dir.equals("")) {
                this.setDir(System.getProperty("user.dir"));
            }
            if (this.m_prefix.equals("")) {
                if (relationName.length() == 0) {
                    throw new IOException("[Saver] Empty filename!!");
                }
                String concat = this.m_dir + File.separator + relationName + add + this.FILE_EXTENSION;
                if (!concat.toLowerCase().endsWith(this.FILE_EXTENSION) && !concat.toLowerCase().endsWith(this.FILE_EXTENSION + ".gz")) {
                    concat = concat + this.FILE_EXTENSION;
                }
                this.setFile(new File(concat));
            } else {
                String concat;
                if (relationName.length() > 0) {
                    relationName = "_" + relationName;
                }
                if (!(concat = this.m_dir + File.separator + this.m_prefix + relationName + add).toLowerCase().endsWith(this.FILE_EXTENSION) && !concat.toLowerCase().endsWith(this.FILE_EXTENSION + ".gz")) {
                    concat = concat + this.FILE_EXTENSION;
                }
                this.setFile(new File(concat));
            }
        }
        catch (Exception ex) {
            System.err.println("File prefix and/or directory could not have been set.");
            ex.printStackTrace();
        }
    }

    public abstract String getFileDescription();

    public String useRelativePathTipText() {
        return "Use relative rather than absolute paths";
    }

    public void setUseRelativePath(boolean rp) {
        this.m_useRelativePath = rp;
    }

    public boolean getUseRelativePath() {
        return this.m_useRelativePath;
    }

    protected static String makeOptionStr(AbstractFileSaver saver) {
        StringBuffer result = new StringBuffer();
        result.append("\n");
        result.append(saver.getClass().getName().replaceAll(".*\\.", ""));
        result.append(" options:\n\n");
        Enumeration enm = saver.listOptions();
        while (enm.hasMoreElements()) {
            Option option = (Option)enm.nextElement();
            result.append(option.synopsis() + "\n");
            result.append(option.description() + "\n");
        }
        return result.toString();
    }

    public static void runFileSaver(AbstractFileSaver saver, String[] options) {
        try {
            String[] tmpOptions = (String[])options.clone();
            if (Utils.getFlag('h', tmpOptions)) {
                System.err.println("\nHelp requested\n" + AbstractFileSaver.makeOptionStr(saver));
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            try {
                saver.setOptions(options);
            }
            catch (Exception ex) {
                System.err.println(AbstractFileSaver.makeOptionStr(saver));
                System.exit(1);
            }
            saver.writeBatch();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

