/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.core.neighboursearch.TreePerformanceStats;
import weka.core.neighboursearch.kdtrees.KDTreeNode;
import weka.core.neighboursearch.kdtrees.KDTreeNodeSplitter;
import weka.core.neighboursearch.kdtrees.SlidingMidPointOfWidestSide;

public class KDTree
extends NearestNeighbourSearch
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 1505717283763272533L;
    protected double[] m_DistanceList;
    protected int[] m_InstList;
    protected KDTreeNode m_Root;
    protected KDTreeNodeSplitter m_Splitter = new SlidingMidPointOfWidestSide();
    protected int m_NumNodes;
    protected int m_NumLeaves;
    protected int m_MaxDepth;
    protected TreePerformanceStats m_TreeStats = null;
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int WIDTH = 2;
    boolean m_NormalizeNodeWidth = true;
    protected EuclideanDistance m_EuclideanDistance;
    protected double m_MinBoxRelWidth;
    protected int m_MaxInstInLeaf;

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jerome H. Friedman and Jon Luis Bentley and Raphael Ari Finkel");
        result.setValue(TechnicalInformation.Field.YEAR, "1977");
        result.setValue(TechnicalInformation.Field.TITLE, "An Algorithm for Finding Best Matches in Logarithmic Expected Time");
        result.setValue(TechnicalInformation.Field.JOURNAL, "ACM Transactions on Mathematics Software");
        result.setValue(TechnicalInformation.Field.PAGES, "209-226");
        result.setValue(TechnicalInformation.Field.MONTH, "September");
        result.setValue(TechnicalInformation.Field.VOLUME, "3");
        result.setValue(TechnicalInformation.Field.NUMBER, "3");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.TECHREPORT);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Andrew Moore");
        additional.setValue(TechnicalInformation.Field.YEAR, "1991");
        additional.setValue(TechnicalInformation.Field.TITLE, "A tutorial on kd-trees");
        additional.setValue(TechnicalInformation.Field.HOWPUBLISHED, "Extract from PhD Thesis");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "University of Cambridge Computer Laboratory Technical Report No. 209");
        additional.setValue(TechnicalInformation.Field.HTTP, "Available from http://www.autonlab.org/autonweb/14665.html");
        return result;
    }

    public KDTree() {
        if (this.m_DistanceFunction instanceof EuclideanDistance) {
            this.m_EuclideanDistance = (EuclideanDistance)this.m_DistanceFunction;
        } else {
            this.m_EuclideanDistance = new EuclideanDistance();
            this.m_DistanceFunction = this.m_EuclideanDistance;
        }
        this.m_MinBoxRelWidth = 0.01;
        this.m_MaxInstInLeaf = 40;
        if (this.getMeasurePerformance()) {
            this.m_TreeStats = new TreePerformanceStats();
            this.m_Stats = this.m_TreeStats;
        }
    }

    public KDTree(Instances insts) {
        super(insts);
        if (this.m_DistanceFunction instanceof EuclideanDistance) {
            this.m_EuclideanDistance = (EuclideanDistance)this.m_DistanceFunction;
        } else {
            this.m_EuclideanDistance = new EuclideanDistance();
            this.m_DistanceFunction = this.m_EuclideanDistance;
        }
        this.m_MinBoxRelWidth = 0.01;
        this.m_MaxInstInLeaf = 40;
        if (this.getMeasurePerformance()) {
            this.m_TreeStats = new TreePerformanceStats();
            this.m_Stats = this.m_TreeStats;
        }
    }

    protected void buildKDTree(Instances instances) throws Exception {
        this.checkMissing(instances);
        if (this.m_EuclideanDistance == null) {
            this.m_EuclideanDistance = new EuclideanDistance(instances);
            this.m_DistanceFunction = this.m_EuclideanDistance;
        } else {
            this.m_EuclideanDistance.setInstances(instances);
        }
        this.m_Instances = instances;
        int numInst = this.m_Instances.numInstances();
        this.m_InstList = new int[numInst];
        for (int i = 0; i < numInst; ++i) {
            this.m_InstList[i] = i;
        }
        double[][] universe = this.m_EuclideanDistance.getRanges();
        this.m_Splitter.setInstances(this.m_Instances);
        this.m_Splitter.setInstanceList(this.m_InstList);
        this.m_Splitter.setEuclideanDistanceFunction(this.m_EuclideanDistance);
        this.m_Splitter.setNodeWidthNormalization(this.m_NormalizeNodeWidth);
        this.m_NumLeaves = 1;
        this.m_NumNodes = 1;
        this.m_MaxDepth = 0;
        this.m_Root = new KDTreeNode(this.m_NumNodes, 0, this.m_Instances.numInstances() - 1, universe);
        this.splitNodes(this.m_Root, universe, this.m_MaxDepth + 1);
    }

    protected void splitNodes(KDTreeNode node, double[][] universe, int depth) throws Exception {
        double[][] nodeRanges = this.m_EuclideanDistance.initializeRanges(this.m_InstList, node.m_Start, node.m_End);
        if (node.numInstances() <= this.m_MaxInstInLeaf || this.getMaxRelativeNodeWidth(nodeRanges, universe) <= this.m_MinBoxRelWidth) {
            return;
        }
        --this.m_NumLeaves;
        if (depth > this.m_MaxDepth) {
            this.m_MaxDepth = depth;
        }
        this.m_Splitter.splitNode(node, this.m_NumNodes, nodeRanges, universe);
        this.m_NumNodes += 2;
        this.m_NumLeaves += 2;
        this.splitNodes(node.m_Left, universe, depth + 1);
        this.splitNodes(node.m_Right, universe, depth + 1);
    }

    protected void findNearestNeighbours(Instance target, KDTreeNode node, int k, NearestNeighbourSearch.MyHeap heap, double distanceToParents) throws Exception {
        if (node.isALeaf()) {
            if (this.m_TreeStats != null) {
                this.m_TreeStats.updatePointCount(node.numInstances());
                this.m_TreeStats.incrLeafCount();
            }
            for (int idx = node.m_Start; idx <= node.m_End; ++idx) {
                double distance;
                if (target == this.m_Instances.instance(this.m_InstList[idx])) continue;
                if (heap.size() < k) {
                    distance = this.m_EuclideanDistance.distance(target, this.m_Instances.instance(this.m_InstList[idx]), Double.POSITIVE_INFINITY, this.m_Stats);
                    heap.put(this.m_InstList[idx], distance);
                    continue;
                }
                NearestNeighbourSearch.MyHeapElement temp = heap.peek();
                distance = this.m_EuclideanDistance.distance(target, this.m_Instances.instance(this.m_InstList[idx]), temp.distance, this.m_Stats);
                if (distance < temp.distance) {
                    heap.putBySubstitute(this.m_InstList[idx], distance);
                    continue;
                }
                if (distance != temp.distance) continue;
                heap.putKthNearest(this.m_InstList[idx], distance);
            }
        } else {
            KDTreeNode further;
            KDTreeNode nearer;
            boolean targetInLeft;
            if (this.m_TreeStats != null) {
                this.m_TreeStats.incrIntNodeCount();
            }
            if (targetInLeft = this.m_EuclideanDistance.valueIsSmallerEqual(target, node.m_SplitDim, node.m_SplitValue)) {
                nearer = node.m_Left;
                further = node.m_Right;
            } else {
                nearer = node.m_Right;
                further = node.m_Left;
            }
            this.findNearestNeighbours(target, nearer, k, heap, distanceToParents);
            if (heap.size() < k) {
                double distanceToSplitPlane = distanceToParents + this.m_EuclideanDistance.sqDifference(node.m_SplitDim, target.value(node.m_SplitDim), node.m_SplitValue);
                this.findNearestNeighbours(target, further, k, heap, distanceToSplitPlane);
                return;
            }
            double distanceToSplitPlane = distanceToParents + this.m_EuclideanDistance.sqDifference(node.m_SplitDim, target.value(node.m_SplitDim), node.m_SplitValue);
            if (heap.peek().distance >= distanceToSplitPlane) {
                this.findNearestNeighbours(target, further, k, heap, distanceToSplitPlane);
            }
        }
    }

    public Instances kNearestNeighbours(Instance target, int k) throws Exception {
        NearestNeighbourSearch.MyHeapElement h;
        this.checkMissing(target);
        if (this.m_Stats != null) {
            this.m_Stats.searchStart();
        }
        NearestNeighbourSearch.MyHeap heap = new NearestNeighbourSearch.MyHeap(this, k);
        this.findNearestNeighbours(target, this.m_Root, k, heap, 0.0);
        if (this.m_Stats != null) {
            this.m_Stats.searchFinish();
        }
        Instances neighbours = new Instances(this.m_Instances, heap.size() + heap.noOfKthNearest());
        this.m_DistanceList = new double[heap.size() + heap.noOfKthNearest()];
        int[] indices = new int[heap.size() + heap.noOfKthNearest()];
        int i = indices.length - 1;
        while (heap.noOfKthNearest() > 0) {
            h = heap.getKthNearest();
            indices[i] = h.index;
            this.m_DistanceList[i] = h.distance;
            --i;
        }
        while (heap.size() > 0) {
            h = heap.get();
            indices[i] = h.index;
            this.m_DistanceList[i] = h.distance;
            --i;
        }
        this.m_DistanceFunction.postProcessDistances(this.m_DistanceList);
        for (int idx = 0; idx < indices.length; ++idx) {
            neighbours.add(this.m_Instances.instance(indices[idx]));
        }
        return neighbours;
    }

    public Instance nearestNeighbour(Instance target) throws Exception {
        return this.kNearestNeighbours(target, 1).instance(0);
    }

    public double[] getDistances() throws Exception {
        if (this.m_Instances == null || this.m_DistanceList == null) {
            throw new Exception("The tree has not been supplied with a set of instances or getDistances() has been called before calling kNearestNeighbours().");
        }
        return this.m_DistanceList;
    }

    public void setInstances(Instances instances) throws Exception {
        super.setInstances(instances);
        this.buildKDTree(instances);
    }

    public void update(Instance instance) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Have to call setInstances(instances) with a set of Instances first.");
        }
        this.addInstanceInfo(instance);
        this.addInstanceToTree(instance, this.m_Root);
    }

    protected void addInstanceToTree(Instance inst, KDTreeNode node) throws Exception {
        if (node.isALeaf()) {
            int[] instList = new int[this.m_Instances.numInstances()];
            try {
                System.arraycopy(this.m_InstList, 0, instList, 0, node.m_End + 1);
                if (node.m_End < this.m_InstList.length - 1) {
                    System.arraycopy(this.m_InstList, node.m_End + 1, instList, node.m_End + 2, this.m_InstList.length - node.m_End - 1);
                }
                instList[node.m_End + 1] = this.m_Instances.numInstances() - 1;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                System.err.println("m_InstList.length: " + this.m_InstList.length + " instList.length: " + instList.length + "node.m_End+1: " + (node.m_End + 1) + "m_InstList.length-node.m_End+1: " + (this.m_InstList.length - node.m_End - 1));
                throw ex;
            }
            this.m_InstList = instList;
            ++node.m_End;
            node.m_NodeRanges = this.m_EuclideanDistance.updateRanges(inst, node.m_NodeRanges);
            this.m_Splitter.setInstanceList(this.m_InstList);
            double[][] universe = this.m_EuclideanDistance.getRanges();
            if (node.numInstances() > this.m_MaxInstInLeaf && this.getMaxRelativeNodeWidth(node.m_NodeRanges, universe) > this.m_MinBoxRelWidth) {
                this.m_Splitter.splitNode(node, this.m_NumNodes, node.m_NodeRanges, universe);
                this.m_NumNodes += 2;
            }
        } else {
            if (this.m_EuclideanDistance.valueIsSmallerEqual(inst, node.m_SplitDim, node.m_SplitValue)) {
                this.addInstanceToTree(inst, node.m_Left);
                this.afterAddInstance(node.m_Right);
            } else {
                this.addInstanceToTree(inst, node.m_Right);
            }
            ++node.m_End;
            node.m_NodeRanges = this.m_EuclideanDistance.updateRanges(inst, node.m_NodeRanges);
        }
    }

    protected void afterAddInstance(KDTreeNode node) {
        ++node.m_Start;
        ++node.m_End;
        if (!node.isALeaf()) {
            this.afterAddInstance(node.m_Left);
            this.afterAddInstance(node.m_Right);
        }
    }

    public void addInstanceInfo(Instance instance) {
        this.m_EuclideanDistance.updateRanges(instance);
    }

    protected void checkMissing(Instances instances) throws Exception {
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance ins = instances.instance(i);
            for (int j = 0; j < ins.numValues(); ++j) {
                if (ins.index(j) == ins.classIndex() || !ins.isMissingSparse(j)) continue;
                throw new Exception("ERROR: KDTree can not deal with missing values. Please run ReplaceMissingValues filter on the dataset before passing it on to the KDTree.");
            }
        }
    }

    protected void checkMissing(Instance ins) throws Exception {
        for (int j = 0; j < ins.numValues(); ++j) {
            if (ins.index(j) == ins.classIndex() || !ins.isMissingSparse(j)) continue;
            throw new Exception("ERROR: KDTree can not deal with missing values. Please run ReplaceMissingValues filter on the dataset before passing it on to the KDTree.");
        }
    }

    protected double getMaxRelativeNodeWidth(double[][] nodeRanges, double[][] universe) {
        int widest = this.widestDim(nodeRanges, universe);
        if (widest < 0) {
            return 0.0;
        }
        return nodeRanges[widest][2] / universe[widest][2];
    }

    protected int widestDim(double[][] nodeRanges, double[][] universe) {
        int classIdx = this.m_Instances.classIndex();
        double widest = 0.0;
        int w = -1;
        if (this.m_NormalizeNodeWidth) {
            for (int i = 0; i < nodeRanges.length; ++i) {
                double newWidest = nodeRanges[i][2] / universe[i][2];
                if (!(newWidest > widest) || i == classIdx) continue;
                widest = newWidest;
                w = i;
            }
        } else {
            for (int i = 0; i < nodeRanges.length; ++i) {
                if (!(nodeRanges[i][2] > widest) || i == classIdx) continue;
                widest = nodeRanges[i][2];
                w = i;
            }
        }
        return w;
    }

    public double measureTreeSize() {
        return this.m_NumNodes;
    }

    public double measureNumLeaves() {
        return this.m_NumLeaves;
    }

    public double measureMaxDepth() {
        return this.m_MaxDepth;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>();
        newVector.addElement("measureTreeSize");
        newVector.addElement("measureNumLeaves");
        newVector.addElement("measureMaxDepth");
        if (this.m_Stats != null) {
            Enumeration e = this.m_Stats.enumerateMeasures();
            while (e.hasMoreElements()) {
                newVector.addElement((String)e.nextElement());
            }
        }
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureMaxDepth") == 0) {
            return this.measureMaxDepth();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        if (this.m_Stats != null) {
            return this.m_Stats.getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (KDTree)");
    }

    public void setMeasurePerformance(boolean measurePerformance) {
        this.m_MeasurePerformance = measurePerformance;
        if (this.m_MeasurePerformance) {
            if (this.m_Stats == null) {
                this.m_TreeStats = new TreePerformanceStats();
                this.m_Stats = this.m_TreeStats;
            }
        } else {
            this.m_TreeStats = null;
            this.m_Stats = null;
        }
    }

    public void centerInstances(Instances centers, int[] assignments, double pc) throws Exception {
        int[] centList = new int[centers.numInstances()];
        for (int i = 0; i < centers.numInstances(); ++i) {
            centList[i] = i;
        }
        this.determineAssignments(this.m_Root, centers, centList, assignments, pc);
    }

    protected void determineAssignments(KDTreeNode node, Instances centers, int[] candidates, int[] assignments, double pc) throws Exception {
        int[] owners = this.refineOwners(node, centers, candidates);
        if (owners.length == 1) {
            for (int i = node.m_Start; i <= node.m_End; ++i) {
                assignments[this.m_InstList[i]] = owners[0];
            }
        } else if (!node.isALeaf()) {
            this.determineAssignments(node.m_Left, centers, owners, assignments, pc);
            this.determineAssignments(node.m_Right, centers, owners, assignments, pc);
        } else {
            this.assignSubToCenters(node, centers, owners, assignments);
        }
    }

    protected int[] refineOwners(KDTreeNode node, Instances centers, int[] candidates) throws Exception {
        int[] owners = new int[candidates.length];
        double minDistance = Double.POSITIVE_INFINITY;
        int ownerIndex = -1;
        int numCand = candidates.length;
        double[] distance = new double[numCand];
        boolean[] inside = new boolean[numCand];
        for (int i = 0; i < numCand; ++i) {
            distance[i] = this.distanceToHrect(node, centers.instance(candidates[i]));
            boolean bl = inside[i] = distance[i] == 0.0;
            if (!(distance[i] < minDistance)) continue;
            minDistance = distance[i];
            ownerIndex = i;
        }
        Instance owner = (Instance)centers.instance(candidates[ownerIndex]).copy();
        int index = 0;
        for (int i = 0; i < numCand; ++i) {
            if (inside[i] || distance[i] == distance[ownerIndex]) {
                owners[index++] = candidates[i];
                continue;
            }
            Instance competitor = (Instance)centers.instance(candidates[i]).copy();
            if (this.candidateIsFullOwner(node, owner, competitor)) continue;
            owners[index++] = candidates[i];
        }
        int[] result = new int[index];
        for (int i = 0; i < index; ++i) {
            result[i] = owners[i];
        }
        return result;
    }

    protected double distanceToHrect(KDTreeNode node, Instance x) throws Exception {
        double distance = 0.0;
        Instance closestPoint = (Instance)x.copy();
        boolean inside = this.clipToInsideHrect(node, closestPoint);
        if (!inside) {
            distance = this.m_EuclideanDistance.distance(closestPoint, x);
        }
        return distance;
    }

    protected boolean clipToInsideHrect(KDTreeNode node, Instance x) {
        boolean inside = true;
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            if (x.value(i) < node.m_NodeRanges[i][0]) {
                x.setValue(i, node.m_NodeRanges[i][0]);
                inside = false;
                continue;
            }
            if (!(x.value(i) > node.m_NodeRanges[i][1])) continue;
            x.setValue(i, node.m_NodeRanges[i][1]);
            inside = false;
        }
        return inside;
    }

    protected boolean candidateIsFullOwner(KDTreeNode node, Instance candidate, Instance competitor) throws Exception {
        Instance extreme = (Instance)candidate.copy();
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            if (competitor.value(i) - candidate.value(i) > 0.0) {
                extreme.setValue(i, node.m_NodeRanges[i][1]);
                continue;
            }
            extreme.setValue(i, node.m_NodeRanges[i][0]);
        }
        boolean isFullOwner = this.m_EuclideanDistance.distance(extreme, candidate) < this.m_EuclideanDistance.distance(extreme, competitor);
        return isFullOwner;
    }

    public void assignSubToCenters(KDTreeNode node, Instances centers, int[] centList, int[] assignments) throws Exception {
        int i;
        int numCent = centList.length;
        if (assignments == null) {
            assignments = new int[this.m_Instances.numInstances()];
            for (i = 0; i < assignments.length; ++i) {
                assignments[i] = -1;
            }
        }
        for (i = node.m_Start; i <= node.m_End; ++i) {
            int newC;
            int instIndex = this.m_InstList[i];
            Instance inst = this.m_Instances.instance(instIndex);
            assignments[instIndex] = newC = this.m_EuclideanDistance.closestPoint(inst, centers, centList);
        }
    }

    public String minBoxRelWidthTipText() {
        return "The minimum relative width of the box. A node is only made a leaf if the width of the split dimension of the instances in a node normalized over the width of the split dimension of all the instances is less than or equal to this minimum relative width.";
    }

    public void setMinBoxRelWidth(double i) {
        this.m_MinBoxRelWidth = i;
    }

    public double getMinBoxRelWidth() {
        return this.m_MinBoxRelWidth;
    }

    public String maxInstInLeafTipText() {
        return "The max number of instances in a leaf.";
    }

    public void setMaxInstInLeaf(int i) {
        this.m_MaxInstInLeaf = i;
    }

    public int getMaxInstInLeaf() {
        return this.m_MaxInstInLeaf;
    }

    public String normalizeNodeWidthTipText() {
        return "Whether if the widths of the KDTree node should be normalized by the width of the universe or not. Where, width of the node is the range of the split attribute based on the instances in that node, and width of the universe is the range of the split attribute based on all the instances (default: false).";
    }

    public void setNormalizeNodeWidth(boolean n) {
        this.m_NormalizeNodeWidth = n;
    }

    public boolean getNormalizeNodeWidth() {
        return this.m_NormalizeNodeWidth;
    }

    public DistanceFunction getDistanceFunction() {
        return this.m_EuclideanDistance;
    }

    public void setDistanceFunction(DistanceFunction df) throws Exception {
        if (!(df instanceof EuclideanDistance)) {
            throw new Exception("KDTree currently only works with EuclideanDistanceFunction.");
        }
        this.m_EuclideanDistance = (EuclideanDistance)df;
        this.m_DistanceFunction = this.m_EuclideanDistance;
    }

    public String nodeSplitterTipText() {
        return "The the splitting method to split the nodes of the KDTree.";
    }

    public KDTreeNodeSplitter getNodeSplitter() {
        return this.m_Splitter;
    }

    public void setNodeSplitter(KDTreeNodeSplitter splitter) {
        this.m_Splitter = splitter;
    }

    public String globalInfo() {
        return "Class implementing the KDTree search algorithm for nearest neighbour search.\nThe connection to dataset is only a reference. For the tree structure the indexes are stored in an array. \nBuilding the tree:\nIf a node has <maximal-inst-number> (option -L) instances no further splitting is done. Also if the split would leave one side empty, the branch is not split any further even if the instances in the resulting node are more than <maximal-inst-number> instances.\n**PLEASE NOTE:** The algorithm can not handle missing values, so it is advisable to run ReplaceMissingValues filter if there are any missing values in the dataset.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.add(new Option("\tNode splitting method to use.\n\t(default: weka.core.neighboursearch.kdtrees.SlidingMidPointOfWidestSide)", "S", 1, "-S <classname and options>"));
        newVector.addElement(new Option("\tSet minimal width of a box\n\t(default: 1.0E-2).", "W", 0, "-W <value>"));
        newVector.addElement(new Option("\tMaximal number of instances in a leaf\n\t(default: 40).", "L", 0, "-L"));
        newVector.addElement(new Option("\tNormalizing will be done\n\t(Select dimension for split, with normalising to universe).", "N", 0, "-N"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String optionString = Utils.getOption('S', options);
        if (optionString.length() != 0) {
            String[] splitMethodSpec = Utils.splitOptions(optionString);
            if (splitMethodSpec.length == 0) {
                throw new Exception("Invalid DistanceFunction specification string.");
            }
            String className = splitMethodSpec[0];
            splitMethodSpec[0] = "";
            this.setNodeSplitter((KDTreeNodeSplitter)Utils.forName(KDTreeNodeSplitter.class, className, splitMethodSpec));
        } else {
            this.setNodeSplitter(new SlidingMidPointOfWidestSide());
        }
        optionString = Utils.getOption('W', options);
        if (optionString.length() != 0) {
            this.setMinBoxRelWidth(Double.parseDouble(optionString));
        } else {
            this.setMinBoxRelWidth(0.01);
        }
        optionString = Utils.getOption('L', options);
        if (optionString.length() != 0) {
            this.setMaxInstInLeaf(Integer.parseInt(optionString));
        } else {
            this.setMaxInstInLeaf(40);
        }
        this.setNormalizeNodeWidth(Utils.getFlag('N', options));
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-S");
        result.add((this.m_Splitter.getClass().getName() + " " + Utils.joinOptions(this.m_Splitter.getOptions())).trim());
        result.add("-W");
        result.add("" + this.getMinBoxRelWidth());
        result.add("-L");
        result.add("" + this.getMaxInstInLeaf());
        if (this.getNormalizeNodeWidth()) {
            result.add("-N");
        }
        return result.toArray(new String[result.size()]);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

