/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Instances;
import weka.gui.beans.AbstractTrainAndTestSetProducer;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.StructureProducer;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;

public class TrainTestSplitMaker
extends AbstractTrainAndTestSetProducer
implements DataSourceListener,
TrainingSetListener,
TestSetListener,
UserRequestAcceptor,
EventConstraints,
Serializable,
StructureProducer {
    private static final long serialVersionUID = 7390064039444605943L;
    private double m_trainPercentage = 66.0;
    private int m_randomSeed = 1;
    private Thread m_splitThread = null;
    private boolean m_dataProvider = false;
    private boolean m_trainingProvider = false;
    private boolean m_testProvider = false;

    public TrainTestSplitMaker() {
        this.m_visual.loadIcons("weka/gui/beans/icons/TrainTestSplitMaker.gif", "weka/gui/beans/icons/TrainTestSplittMaker_animated.gif");
        this.m_visual.setText("TrainTestSplitMaker");
    }

    private Instances getUpstreamStructure() {
        if (this.m_listenee != null && this.m_listenee instanceof StructureProducer) {
            if (this.m_dataProvider) {
                return ((StructureProducer)this.m_listenee).getStructure("dataSet");
            }
            if (this.m_trainingProvider) {
                return ((StructureProducer)this.m_listenee).getStructure("trainingSet");
            }
            if (this.m_testProvider) {
                return ((StructureProducer)this.m_listenee).getStructure("testSet");
            }
        }
        return null;
    }

    public Instances getStructure(String eventName) {
        if (!eventName.equals("trainingSet") && !eventName.equals("testSet")) {
            return null;
        }
        if (this.m_listenee == null) {
            return null;
        }
        if (eventName.equals("trainingSet") && this.m_trainingListeners.size() == 0) {
            return null;
        }
        if (eventName.equals("testSet") && this.m_testListeners.size() == 0) {
            return null;
        }
        return this.getUpstreamStructure();
    }

    public synchronized void connectionNotification(String eventName, Object source) {
        super.connectionNotification(eventName, source);
        if (this.connectionAllowed(eventName)) {
            if (eventName.equals("dataSet")) {
                this.m_dataProvider = true;
                this.m_trainingProvider = false;
                this.m_testProvider = false;
            } else if (eventName.equals("trainingSet")) {
                this.m_dataProvider = false;
                this.m_trainingProvider = true;
                this.m_testProvider = false;
            } else if (eventName.equals("testSet")) {
                this.m_dataProvider = false;
                this.m_trainingProvider = false;
                this.m_testProvider = true;
            }
        }
    }

    public synchronized void disconnectionNotification(String eventName, Object source) {
        super.disconnectionNotification(eventName, source);
        if (this.m_listenee == null) {
            this.m_dataProvider = false;
            this.m_trainingProvider = false;
            this.m_testProvider = false;
        }
    }

    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        return "Split an incoming data set into separate train and test sets.";
    }

    public String trainPercentTipText() {
        return "The percentage of data to go into the training set";
    }

    public void setTrainPercent(double newTrainPercent) {
        this.m_trainPercentage = newTrainPercent;
    }

    public double getTrainPercent() {
        return this.m_trainPercentage;
    }

    public String seedTipText() {
        return "The randomization seed";
    }

    public void setSeed(int newSeed) {
        this.m_randomSeed = newSeed;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public void acceptTrainingSet(TrainingSetEvent e) {
        Instances trainingSet = e.getTrainingSet();
        DataSetEvent dse = new DataSetEvent(this, trainingSet);
        this.acceptDataSet(dse);
    }

    public void acceptTestSet(TestSetEvent e) {
        Instances testSet = e.getTestSet();
        DataSetEvent dse = new DataSetEvent(this, testSet);
        this.acceptDataSet(dse);
    }

    public void acceptDataSet(DataSetEvent e) {
        if (this.m_splitThread == null) {
            final Instances dataSet = new Instances(e.getDataSet());
            this.m_splitThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        block10: {
                            try {
                                dataSet.randomize(new Random(TrainTestSplitMaker.this.m_randomSeed));
                                int trainSize = (int)Math.round((double)dataSet.numInstances() * TrainTestSplitMaker.this.m_trainPercentage / 100.0);
                                int testSize = dataSet.numInstances() - trainSize;
                                Instances train = new Instances(dataSet, 0, trainSize);
                                Instances test = new Instances(dataSet, trainSize, testSize);
                                TrainingSetEvent tse = new TrainingSetEvent(TrainTestSplitMaker.this, train);
                                tse.m_setNumber = 1;
                                tse.m_maxSetNumber = 1;
                                if (TrainTestSplitMaker.this.m_splitThread != null) {
                                    TrainTestSplitMaker.this.notifyTrainingSetProduced(tse);
                                }
                                TestSetEvent teste = new TestSetEvent(TrainTestSplitMaker.this, test);
                                teste.m_setNumber = 1;
                                teste.m_maxSetNumber = 1;
                                if (TrainTestSplitMaker.this.m_splitThread != null) {
                                    TrainTestSplitMaker.this.notifyTestSetProduced(teste);
                                    break block10;
                                }
                                if (TrainTestSplitMaker.this.m_logger == null) break block10;
                                TrainTestSplitMaker.this.m_logger.logMessage("[TrainTestSplitMaker] " + TrainTestSplitMaker.this.statusMessagePrefix() + " Split has been canceled!");
                                TrainTestSplitMaker.this.m_logger.statusMessage(TrainTestSplitMaker.this.statusMessagePrefix() + "INTERRUPTED");
                            }
                            catch (Exception ex) {
                                this.stop();
                                if (TrainTestSplitMaker.this.m_logger != null) {
                                    TrainTestSplitMaker.this.m_logger.statusMessage(TrainTestSplitMaker.this.statusMessagePrefix() + "ERROR (See log for details)");
                                    TrainTestSplitMaker.this.m_logger.logMessage("[TrainTestSplitMaker] " + TrainTestSplitMaker.this.statusMessagePrefix() + " problem during split creation. " + ex.getMessage());
                                }
                                ex.printStackTrace();
                                Object var8_9 = null;
                                if (this.isInterrupted() && TrainTestSplitMaker.this.m_logger != null) {
                                    TrainTestSplitMaker.this.m_logger.logMessage("[TrainTestSplitMaker] " + TrainTestSplitMaker.this.statusMessagePrefix() + " Split has been canceled!");
                                    TrainTestSplitMaker.this.m_logger.statusMessage(TrainTestSplitMaker.this.statusMessagePrefix() + "INTERRUPTED");
                                }
                                TrainTestSplitMaker.this.block(false);
                                return;
                            }
                        }
                        Object var8_8 = null;
                        if (this.isInterrupted() && TrainTestSplitMaker.this.m_logger != null) {
                            TrainTestSplitMaker.this.m_logger.logMessage("[TrainTestSplitMaker] " + TrainTestSplitMaker.this.statusMessagePrefix() + " Split has been canceled!");
                            TrainTestSplitMaker.this.m_logger.statusMessage(TrainTestSplitMaker.this.statusMessagePrefix() + "INTERRUPTED");
                        }
                        TrainTestSplitMaker.this.block(false);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (this.isInterrupted() && TrainTestSplitMaker.this.m_logger != null) {
                            TrainTestSplitMaker.this.m_logger.logMessage("[TrainTestSplitMaker] " + TrainTestSplitMaker.this.statusMessagePrefix() + " Split has been canceled!");
                            TrainTestSplitMaker.this.m_logger.statusMessage(TrainTestSplitMaker.this.statusMessagePrefix() + "INTERRUPTED");
                        }
                        TrainTestSplitMaker.this.block(false);
                        throw throwable;
                    }
                }
            };
            this.m_splitThread.setPriority(1);
            this.m_splitThread.start();
            this.block(true);
            this.m_splitThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTestSetProduced(TestSetEvent tse) {
        Vector l;
        TrainTestSplitMaker trainTestSplitMaker = this;
        synchronized (trainTestSplitMaker) {
            l = (Vector)this.m_testListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size() && this.m_splitThread != null; ++i) {
                ((TestSetListener)l.elementAt(i)).acceptTestSet(tse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingSetProduced(TrainingSetEvent tse) {
        Vector l;
        TrainTestSplitMaker trainTestSplitMaker = this;
        synchronized (trainTestSplitMaker) {
            l = (Vector)this.m_trainingListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size() && this.m_splitThread != null; ++i) {
                ((TrainingSetListener)l.elementAt(i)).acceptTrainingSet(tse);
            }
        }
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_splitThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_splitThread != null) {
            Thread temp = this.m_splitThread;
            this.m_splitThread = null;
            temp.interrupt();
            temp.stop();
        }
    }

    public boolean isBusy() {
        return this.m_splitThread != null;
    }

    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_splitThread != null) {
            newVector.addElement("Stop");
        }
        return newVector.elements();
    }

    public void performRequest(String request) {
        if (request.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(request + " not supported (TrainTestSplitMaker)");
        }
        this.stop();
    }

    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        if (this.m_listenee instanceof EventConstraints) {
            return ((EventConstraints)this.m_listenee).eventGeneratable("dataSet") || ((EventConstraints)this.m_listenee).eventGeneratable("trainingSet") || ((EventConstraints)this.m_listenee).eventGeneratable("testSet");
        }
        return true;
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

