/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public final class Values
implements RevisionHandler {
    int numInstances;
    int missingInstances;
    int first;
    int last;
    int attr;
    double sum;
    double sqrSum;
    double va;
    double sd;

    public Values(int low, int high, int attribute, Instances inst) {
        int count = 0;
        this.numInstances = high - low + 1;
        this.missingInstances = 0;
        this.first = low;
        this.last = high;
        this.attr = attribute;
        this.sum = 0.0;
        this.sqrSum = 0.0;
        for (int i = this.first; i <= this.last; ++i) {
            if (!inst.instance(i).isMissing(this.attr)) {
                ++count;
                double value = inst.instance(i).value(this.attr);
                this.sum += value;
                this.sqrSum += value * value;
            }
            if (count > 1) {
                this.va = (this.sqrSum - this.sum * this.sum / (double)count) / (double)count;
                this.va = Math.abs(this.va);
                this.sd = Math.sqrt(this.va);
                continue;
            }
            this.va = 0.0;
            this.sd = 0.0;
        }
    }

    public final String toString() {
        StringBuffer text = new StringBuffer();
        text.append("Print statistic values of instances (" + this.first + "-" + this.last + "\n");
        text.append("    Number of instances:\t" + this.numInstances + "\n");
        text.append("    NUmber of instances with unknowns:\t" + this.missingInstances + "\n");
        text.append("    Attribute:\t\t\t:" + this.attr + "\n");
        text.append("    Sum:\t\t\t" + this.sum + "\n");
        text.append("    Squared sum:\t\t" + this.sqrSum + "\n");
        text.append("    Stanard Deviation:\t\t" + this.sd + "\n");
        return text.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

