% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archivedb.R
\name{archivedb}
\alias{archivedb}
\alias{archivedb_down}
\alias{archivedb_load}
\alias{archivedb_npkgs}
\alias{archivedb_pkgs}
\alias{archivedb_rempkgs}
\alias{archivedb_list}
\alias{p_downarch}
\title{CRAN archive (CRAN-archive.html + archivedb)}
\usage{
archivedb_down(filename = "CRAN-archive.html", dir = ".",
  url = "https://cran.r-project.org/src/contrib/Archive")

archivedb_load(filename = "CRAN-archive.html")

archivedb_npkgs(archivedb = get("archivedb", envir = .GlobalEnv),
  crandb = get("crandb", envir = .GlobalEnv))

archivedb_pkgs(archivedb = get("archivedb", envir = .GlobalEnv))

archivedb_rempkgs(archivedb = get("archivedb", envir = .GlobalEnv),
  crandb = get("crandb", envir = .GlobalEnv))

archivedb_list(archivedb = get("archivedb", envir = .GlobalEnv),
  crandb = get("crandb", envir = .GlobalEnv))

p_downarch(..., char = NULL, dir = ".", archivedb = get("archivedb",
  envir = .GlobalEnv),
  url = "https://cran.r-project.org/src/contrib/Archive")
}
\arguments{
\item{filename}{character. The path to file "CRAN-archive.html" (or equivalent).}

\item{dir}{character. The directory where \code{filename} or tar.gz files 
are saved. Default value \code{"."} is the current directory.}

\item{url}{character. The url address of CRAN archive html file.}

\item{archivedb}{data.frame \code{archivedb}. The archivedb data.frame format loaded 
in memory by \code{archivedb_down} or \code{archivedb_load}.}

\item{crandb}{data.frame \code{crandb}. The data.frame of CRAN packages.}

\item{...}{any format recognized by \code{\link{cnsc}}, except list.
A vector of packages.}

\item{char}{(name to) a character vector. Use this argument if \code{...} fails 
or if you call the function from another function. If used, 
argument \code{...} is ignored.}
}
\description{
The following functions deal with the packages archived in CRAN. The html file 
downloaded from CRAN contains the regular packages that have been updated once and 
the packages that have been removed from CRAN by CRAN administrators. It does not contain
the first version of the packages uploaded to CRAN and never updated. These files and
the files removed from CRAN index can be guessed through a comparison with \code{crandb}. 

\code{archivedb_down} downloads from CRAN the html file of the archived packages, saves 
it on the disk under the name \code{filename}, extracts from it and loads in .GlobalEnv
a data.frame named \code{archivedb}.

\code{archivedb_load} reads the html file \code{filename} saved on the disk, extracts 
from it and loads in .GlobalEnv a data.frame named \code{archivedb}.

\code{archivedb_npkgs} returns the number of packages listed each category: number of
packages in \code{crandb}, in \code{archivedb}, at first version, at subsequent version
and removed from \code{crandb} (CRAN index). 

\code{archivedb_pkgs} returns the packages listed in CRAN archive (= \code{archivedb}). 

\code{archivedb_rempkgs} returns the archived packages removed from CRAN regular index.

\code{archivedb_list} compares the data.frame \code{archivedb} and \code{crandb} and
returns a list with the following items:
\itemize{
\item{pkgs_crandb: the packages listed in \code{crandb}.}
\item{pkgs_archivedb: the packages listed in \code{archivedb}.}
\item{pkgs_first: the packages in first version in \code{crandb}.}
\item{pkgs_updated: the packages with more than one version in \code{crandb}.}
\item{pkgs_removed: the archived packages removed from CRAN regular index, 
i.e. not listed in \code{crandb}.}
\item{dfr_crandb: data.frame pkgs_crandb + Published date.}
\item{dfr_archivedb: data.frame pkgs_archivedb + Archived date.}
\item{dfr_first: data.frame pkgs_first + Published date.}
\item{dfr_updated: data.frame pkgs_updated + Published date.}
\item{dfr_removed: data.frame pkgs_removed+ Archived date.}
\item{npkgs: the number of packages in each category.}
}

\code{p_downarch} downloads the latest tar.gz version of the package(s) listed in 
CRAN archive.
}
\examples{
### DOWNLOAD archivedb AND COMPARE IT WITH crandb.
## In real life, download archivedb and crandb from CRAN
## with the functions archivedb_down() and crandb_down().  
## In this example, we load two small files (50 and 43 packages).

crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))
archivedb_load(system.file("aabb", "zCRAN-archive.html", package = "RWsearch")) 
archivedb_npkgs()

lst <- archivedb_list()
lapply(lst, tail)
range(lst$dfr_removed$Archived)
hist(lst$dfr_removed$Archived, breaks = 15, freq = TRUE, las = 1)

## Download the latest tar.gz version from CRAN archive 
## (this works for both both existing and removed packages).
p_downarch(fitur, zmatrix, dir = file.path(tempdir(), "pdownarch"))

}
