% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StemID.R
\docType{class}
\name{Ltree-class}
\alias{Ltree-class}
\alias{Ltree}
\alias{Ltree}
\title{The Ltree Class}
\arguments{
\item{object}{An Ltree object.}
}
\description{
The Ltree class is the central object storing all information generated during lineage tree inference by the StemID algorithm.
It comprises a number of slots for a variety of objects.

validity function for Ltree
}
\section{Slots}{

\describe{
\item{\code{sc}}{An \code{SCseq} object with the RaceID3 analysis of the single-cell RNA-seq data for which a lineage tree should be derived.}

\item{\code{ldata}}{List object storing information on the clustering partition, the distance matrix, and the cluster centers in dimensionally-reduced
input space and in two-dimensional t-sne space. Elements:
\code{lp}: vector with the filtered partition into clusters after discarding clusters with cthr cells or less.
\code{pdi}:matrix with the coordinates of all cells in the embedded space. Clusters with \code{cthr} transcripts or less were discarded (see function \code{projcells}).
Rows are medoids and columns are coordinates.
\code{cn}: data.frame with the coordinates of the cluster medoids in the embedded space. Clusters with \code{cthr} transcripts or less were discarded.
Rows are medoids and columns are coordinates.
\code{m}: vector with the numbers of the clusters which survived the filtering.
\code{pdil}:    data.frame with coordinates of cells in the two-dimensional t-SNE representation computed by RaceID3. Clusters with \code{cthr} transcripts or less were
discarded. Rows are cells and columns are coordinates.
\code{cnl}:    data.frame with the coordinates of the cluster medoids in the two-dimensional t-SNE representation computed by RaceID3. Clusters with \code{cthr}
transcripts or less were discarded. Rows are medoids and columns are coordinates.}

\item{\code{entropy}}{Vector with transcriptome entropy computed for each cell.}

\item{\code{trproj}}{List containing two data.frames. Elements:
\code{res}:    data.frame with three columns for each cell. The first column \code{o} shows the cluster of a cell,
the second column \code{l} shows the cluster number for the link the cell is assigned to, and the third column \code{h} shows the projection as a fraction of the length
of the inter-cluster link. Parallel projections are positive, while anti-parallel projections are negative.
\code{rma}: data.frame with all projection coordinates for each cell. Rows are cells and columns are clusters. Projections are given as a fraction of the length of the
inter-cluster link. Parallel projections are positive, while anti-parallel projections are negative. The column corresponding to the originating cluster of a cell
shows \code{NA}.}

\item{\code{par}}{List of parameters used for the StemID2 analysis.}

\item{\code{prback}}{data.frame of the same structure as the \code{trproj$res}. In case randomizations are used to compute significant projections, the projections of all
\code{pdishuff} randomizations are appended to this data.frame and therefore the number of rows corresponds to the number of cells multiplied by \code{pdishuf}. See
function \code{projback}.}

\item{\code{prbacka}}{data.frame reporting the aggregated results of the randomizations with four columns. Column \code{n} denotes the number of the randomization sample,
column \code{o} and \code{l} contain the numbers of the originating and the terminal cluster, respectively, for each inter-cluster link and column \code{count} shows
the number of cells assigned to this link in randomization sample \code{n}. The discrete distribution for the computation of the link p-value is given by the data
contained in this object (if \code{nmode=FALSE}).}

\item{\code{ltcoord}}{Matrix storing projection coordinates of all cells in the two-dimensional t-SNE space, used for visualization.}

\item{\code{prtree}}{List with two elements. The first element \code{l} stores a list with the projection coordinates for each link. The name of each element identifies the
link and is composed of two cluster numbers separated by a dot. The second element \code{n} is a list of the same structure and contains the cell names corresponding
to the projection coordinates stored in \code{l}.}

\item{\code{cdata}}{list of data.frames, each with cluster ids as rows and columns:
\code{counts} data.frame indicating the number of cells on the links connecting the cluster of origin (rows) to other clusters (columns).
\code{counts.br} data.frame containing the cell counts on cluster connections averaged across the randomized background samples (if \code{nmode = FALSE}) or as derived
from sampling statistics (if \code{nmode = TRUE}).
\code{pv.e} matrix of enrichment p-values estimated from sampling statistics (if \code{nmode = TRUE}); entries are 0 if the observed number of cells on the respective
link exceeds the \code{(1 – pethr)}-quantile of the randomized background distribution and 0.5 otherwise (if \code{nmode = FALSE}).
\code{pv.d} matrix of depletion p-values estimated from sampling statistics (if \code{nmode = TRUE}); entries are 0 if the observed number of cells on the respective
link is lower than the \code{pethr}-quantile of the randomized background distribution and 0.5 otherwise (if \code{nmode = FALSE}).
\code{pvn.e} matrix of enrichment p-values estimated from sampling statistics (if \code{nmode = TRUE}); 1- quantile, with the quantile estimated from the number of cells on a link as derived from the randomized background distribution (if \code{nmode = FALSE}). 
\code{pvn.d} matrix of depletion p-values estimated from sampling statistics (if \code{nmode = TRUE}); quantile estimated from the number of cells on a link as derived from the randomized background distribution (if \code{nmode = FALSE}).}
}}

