% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StemID.R
\name{lineagegraph}
\alias{lineagegraph}
\title{Inference of a Lineage Graph}
\usage{
lineagegraph(object, verbose = TRUE)
}
\arguments{
\item{object}{\code{Ltree} class object.}

\item{verbose}{logical. If \code{FALSE} then status output messages are disabled. Default is \code{TRUE}.}
}
\value{
An Ltree class object with lineage graph-related data stored in slots \code{ltcoord}, \code{prtree}, and \code{cdata}.
}
\description{
This function assembles a lineage graph based on the cell projections onto inter-cluster links.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
sc <- clustexp(sc)
sc <- findoutliers(sc)
sc <- comptsne(sc)
ltr <- Ltree(sc)
ltr <- compentropy(ltr)
ltr <- projcells(ltr)
ltr <- lineagegraph(ltr)
}
