% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{cleanNN}
\alias{cleanNN}
\title{Function for pruning k-nearest neighborhoods based on neighborhood overlap}
\usage{
cleanNN(res, minN = 2, no_cores = NULL)
}
\arguments{
\item{res}{List object with k nearest neighbour information returned by \code{pruneKnn} function.}

\item{minN}{Positive integer number. Minimum of neighborhoods across the k nearest neighbours of a cell expected to share a neighbor with the cell. Default is 2.}

\item{no_cores}{Positive integer number. Number of cores for multithreading. If set to \code{NULL} then the number of available cores minus two is used. Default is \code{NULL}.}
}
\value{
A \code{res} object with update pvalue entries (\code{pvM} element).
}
\description{
This function compares the neighborhood of a cell with the neighorhoods of all of its k nearest neighors and prunes links to neighbors that do not co-occur in a defined minimum number of neighborhoods by setting their link p-value (entry  in \code{pvM} data.frame of \code{res} input object) to 0.
}
