% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{plotfeatmap}
\alias{plotfeatmap}
\title{Highlighting feature values in a dimensional reduction representation}
\usage{
plotfeatmap(
  object,
  g,
  n = NULL,
  logsc = FALSE,
  fr = FALSE,
  um = FALSE,
  cells = NULL,
  cex = 1,
  map = TRUE,
  leg = TRUE,
  flo = NULL,
  ceil = NULL
)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{g}{Vector of real numbered features to highlight in the dimensional reduction representation, NAs will be highlighted in grey.}

\item{n}{String of characters representing the title of the plot. Default is \code{NULL} and the first element of \code{g} is chosen.}

\item{logsc}{logical. If \code{TRUE}, then feature values are log2-transformed. Default is \code{FALSE}.
and untransformed values are shown.}

\item{fr}{logical. If \code{TRUE} then plot Fruchterman-Rheingold layout. Default is \code{FALSE}.}

\item{um}{logical. If \code{TRUE} then plot umap dimensional reduction representation. Default is \code{FALSE}.}

\item{cells}{Vector of valid cell names corresponding to column names of slot \code{ndata} of the \code{SCseq} object. Gene expression is ony shown for
this subset.}

\item{cex}{size of data points. Default value is 1.}

\item{map}{logical. If \code{TRUE} then data points are shown. Default value is \code{TRUE}.}

\item{leg}{logical. If \code{TRUE} then the legend is shown. Default value is \code{TRUE}.}

\item{flo}{Numeric. Lower bound for feature values. All values smaller then \code{flo} are replaced by \code{flo}.
#' Default is \code{NULL} and no \code{fllo} is applied.}

\item{ceil}{Numeric. Upper bound for feature values. All values larger then \code{ceil} are replaced by \code{ceil}.
Default is \code{NULL} and no \code{ceil} is applied.}
}
\value{
None
}
\description{
This functions highlights feature values in a two-dimensional t-SNE map, UMAP, or a Fruchterman-Rheingold graph layout
of the singe-cell transcriptome data.
}
