% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_stress.R
\name{mapResiduals}
\alias{mapResiduals}
\title{Get a table of residuals from an acmap}
\usage{
mapResiduals(map, exclude_nd = FALSE, optimization_number = 1)
}
\arguments{
\item{map}{The acmap object}

\item{exclude_nd}{Should values associated with non-detectable measurements
like <10 be set to NA}

\item{optimization_number}{The optimization number}
}
\value{
Returns a matrix of residuals, showing the residual error between
map distance and table distance for each antigen-sera pair.
}
\description{
This is the difference between the table distance and the map distance
}
\seealso{
Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{dimensionTestMap}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()},
\code{\link{triangulationBlobs}()},
\code{\link{unstableMaps}}

Other functions relating to map stress calculation: 
\code{\link{logtiterTable}()},
\code{\link{mapDistances}()},
\code{\link{pointStress}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()}
}
\concept{functions relating to map stress calculation}
\concept{map diagnostic functions}
