% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_new.R
\name{acmap}
\alias{acmap}
\title{Generate a new acmap object}
\usage{
acmap(
  ag_names = NULL,
  sr_names = NULL,
  titer_table = NULL,
  ag_coords = NULL,
  sr_coords = NULL,
  check_duplicates = TRUE,
  ...
)
}
\arguments{
\item{ag_names}{Antigen names}

\item{sr_names}{Sera names}

\item{titer_table}{Table of titer data}

\item{ag_coords}{Antigenic coordinates for an optimization run record
(optional)}

\item{sr_coords}{Sera coordinates for an optimization run record (optional)}

\item{check_duplicates}{Issue a warning if duplicate antigen or sera names
are found}

\item{...}{Further arguments passed to \code{addOptimization()}}
}
\value{
Returns the new acmap object
}
\description{
This function generates a new acmap object, the base object for storing map
data in the Racmacs package.
}
\details{
The fundamental unit of the Racmacs package is the \code{acmap} object,
short for Antigenic Cartography MAP. This object contains all the
information about an antigenic map. You can read in a new acmap object from
a file with the function \code{read.acmap()} and create a new acmap object
within an R session using the \code{acmap()} function.
}
\seealso{
See \code{optimizeMap()} for generating new optimizations estimating
antigen similarity from the acmap titer data.

Other functions for working with map data: 
\code{\link{addOptimization}()},
\code{\link{agReactivityAdjustments}()},
\code{\link{as.json}()},
\code{\link{edit_agNames}()},
\code{\link{edit_srNames}()},
\code{\link{keepBestOptimization}()},
\code{\link{keepSingleOptimization}()},
\code{\link{layerNames}()},
\code{\link{orderPoints}},
\code{\link{read.acmap}()},
\code{\link{read.titerTable}()},
\code{\link{removePoints}},
\code{\link{save.acmap}()},
\code{\link{save.coords}()},
\code{\link{save.titerTable}()},
\code{\link{subsetCommonPoints}},
\code{\link{subsetMap}()}
}
\concept{functions for working with map data}
