% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_props_optimizations.R
\name{colBases}
\alias{colBases}
\alias{minColBasis}
\alias{minColBasis<-}
\alias{fixedColBases}
\alias{fixedColBases<-}
\title{Getting and setting column bases}
\usage{
minColBasis(map, optimization_number = 1)
minColBasis(map, optimization_number = 1) <- value
fixedColBases(map, optimization_number = 1)
fixedColBases(map, optimization_number = 1) <- value
}
\arguments{
\item{map}{The acmap data object}

\item{optimization_number}{The optimization run from which to get / set the data}

\item{value}{New value to set}
}
\value{
Returns either the requested attribute when using a getter function or

the updated acmap object when using the setter function.
}
\description{
Functions to get and set column bases specified for an optimization run,
either through the minimum column basis or through a vector of specified
column bases.
}
\details{
In general a map can have column bases that are specified either
through a minimum column basis or a vector of fixed column bases for each
sera. When you call \code{minColBasis()}, it will return the minimum column
basis if it has been set, or "fixed" if column bases have instead been
fixed directly. The \code{colBases()} function will return the column bases as
calculated for a given optimization run. Setting column bases through this
function with \verb{colBases()<-} will fix the column bases to the supplied
vector of values.

Note that although the output from \code{colBases()} might be the same in a case
where a minimum column basis was set or a case where column bases were set
explicitly, when a minimum column basis is set, the column bases will still
depend on the log titers recorded against a given sera, so changing the
titers may therefore change the actual column bases calculated. For fixed
column bases case, column bases will remain fixed at their values
independently of measured titers.
}
\seealso{
Other map optimization attribute functions: 
\code{\link{mapComment}()},
\code{\link{mapDimensions}()},
\code{\link{mapStress}()},
\code{\link{mapTransformation}()},
\code{\link{ptBaseCoords}()},
\code{\link{ptCoords}()}
}
\concept{map optimization attribute functions}
