% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_loadsave.R
\name{save.coords}
\alias{save.coords}
\title{Save acmap coordinate data to a file}
\usage{
save.coords(
  map,
  filename,
  optimization_number = 1,
  antigens = TRUE,
  sera = TRUE
)
}
\arguments{
\item{map}{The acmap data object.}

\item{filename}{Path to the file.}

\item{optimization_number}{Optimization number from which to take coordinates}

\item{antigens}{Antigens to include, either as a numeric vector of indices or
character vector of names.}

\item{sera}{Sera to include, either as a numeric vector of indices or
character vector of names.}
}
\value{
No return value, called for the side effect of saving the
coordinate data.
}
\description{
Saves acmap coordinate data of all or specified antigens and sera to a .csv
file.
}
\seealso{
Other functions for working with map data: 
\code{\link{acmap}()},
\code{\link{addOptimization}()},
\code{\link{agReactivityAdjustments}()},
\code{\link{as.json}()},
\code{\link{edit_agNames}()},
\code{\link{edit_srNames}()},
\code{\link{keepBestOptimization}()},
\code{\link{keepSingleOptimization}()},
\code{\link{layerNames}()},
\code{\link{orderPoints}},
\code{\link{read.acmap}()},
\code{\link{read.titerTable}()},
\code{\link{removePoints}},
\code{\link{save.acmap}()},
\code{\link{save.titerTable}()},
\code{\link{subsetCommonPoints}},
\code{\link{subsetMap}()}
}
\concept{functions for working with map data}
