% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_props.R
\name{titerTableFlat}
\alias{titerTableFlat}
\alias{titerTableFlat<-}
\title{Getting and setting the flat titer table}
\usage{
titerTableFlat(map)

titerTableFlat(map) <- value
}
\arguments{
\item{map}{The acmap object}

\item{value}{A character matrix of titers to set}
}
\value{
Returns a character matrix of titers.
}
\description{
These are underlying functions to get and set the "flat" version of the titer
table only. When a map is merged, the titer tables are merged but a record of
the original titers associated with each map are kept as titer table layers
so that information on the original set of titers that made up the merge is
not lost. At the same time, the merged titer version of the titer table is
created and saved as the titer_table_flat attribute. When you access titers
through the \code{titerTable()} function, the flat version of the titer table is
retrieved (only really a relevant distinction for merged maps). When you set
titers through \verb{titerTable<-()} titer table layers are lost. These functions
allow you to manipulate the flat version without affecting the titer table
layers information.
}
\seealso{
Other map attribute functions: 
\code{\link{acmapAttributes}},
\code{\link{adjustedLogTiterTable}()},
\code{\link{adjustedTiterTable}()},
\code{\link{dilutionStepsize}()},
\code{\link{logtiterTableLayers}()},
\code{\link{mapDescription}()},
\code{\link{mapName}()},
\code{\link{titerTableLayers}()},
\code{\link{titerTable}()}
}
\concept{map attribute functions}
