% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radSensitivitySig.R
\name{radSensitivitySig}
\alias{radSensitivitySig}
\title{Creates a signature representing the association between gene expression (or
other molecular profile) and radiation dose response, for use in radiation sensitivity
analysis.}
\usage{
radSensitivitySig(rSet, mDataType, radiation.types, features,
  sensitivity.measure = "AUC_recomputed",
  molecular.summary.stat = c("mean", "median", "first", "last", "or",
  "and"), sensitivity.summary.stat = c("mean", "median", "first",
  "last"), returnValues = c("estimate", "pvalue", "fdr"),
  sensitivity.cutoff, standardize = c("SD", "rescale", "none"),
  nthread = 1, verbose = TRUE, ...)
}
\arguments{
\item{rSet}{[PharmacoSet] a PharmacoSet of the perturbation experiment type}

\item{mDataType}{[character] which one of the molecular data types to use
in the analysis, out of dna, rna, rnaseq, snp, cnv}

\item{radiation.types}{[character] a vector of radiation.types for which to compute the
signatures. Should match the names used in the PharmacoSet.}

\item{features}{[character] a vector of features for which to compute the
signatures. Should match the names used in correspondant molecular data in PharmacoSet.}

\item{sensitivity.measure}{[character] which measure of the radiation
sensitivity should the function use for its computations? Use the
sensitivityMeasures function to find out what measures are available for each PSet.}

\item{molecular.summary.stat}{What summary statistic should be used to
summarize duplicates for cell line molecular profile measurements?}

\item{sensitivity.summary.stat}{What summary statistic should be used to
summarize duplicates for cell line sensitivity measurements?}

\item{returnValues}{[character] Which of estimate, t-stat, p-value and fdr
should the function return for each gene?}

\item{sensitivity.cutoff}{Allows to provide upper and lower bounds to
sensitivity measures in the cases where the values exceed physical values
due to numerical or other errors.}

\item{standardize}{[character] One of "SD", "rescale", or "none", for the form of standardization of
the data to use. If "SD", the the data is scaled so that SD = 1. If rescale, then the data is scaled so that the 95%
interquantile range lies in [0,1]. If none no rescaling is done.}

\item{nthread}{[numeric] if multiple cores are available, how many cores
should the computation be parallelized over?}

\item{verbose}{[boolean] 'TRUE' if the warnings and other infomrative message shoud be displayed}

\item{...}{additional arguments not currently fully supported by the function}
}
\value{
[list] a 3D array with genes in the first dimension, radiation.types in the
  second, and return values in the third.
}
\description{
Given a RadioSet of the sensitivity experiment type, and a list of drugs,
the function will compute a signature for the effect gene expression on the
molecular profile of a cell. The function returns the estimated coefficient,
the t-stat, the p-value and the false discovery rate associated with that
coefficient, in a 3 dimensional array, with genes in the first direction,
drugs in the second, and the selected return values in the third.
}
\examples{
data(Cleveland_small)
rad.sensitivity <- radSensitivitySig(Cleveland_small, mDataType="rna",
             nthread=1, features = fNames(Cleveland_small, "rna")[1],
             radiation.types=radiationTypes(Cleveland_small))
print(rad.sensitivity)

}
