% Generated by roxygen2 (4.0.2.9000): do not edit by hand
% Please edit documentation in R/pp.r
\name{pp}
\alias{pp}
\title{Ruby-like string interpolation}
\usage{
pp(..., envir = parent.frame(), sep = "", collapse = "")
}
\arguments{
\item{...}{arbitrary many character vectors, that will be concatenated
using the \code{sep} parameter as delimiter. Any non-length 1 vectors
will also be collapsed using the \code{collapse} parameter.}

\item{envir}{environment. Where to evaluate any interpolated strings,
by default \code{parent.frame()}, the current local environment.}

\item{sep}{character. The delimiter to use to concatenate passed
strings, by default the empty string \code{''}.}

\item{collapse}{character. The delimiter to use to concatenate passed
 character vectors of length greater than 1, by default the empty string
\code{''}.}
}
\description{
To interpolate any R object into a string, it can be wrapped in \code{#\{...\}}
and within a string. This is equivalent to evaluating whatever is in this block
within the current environment (see \code{base::environment} when called with
no arguments).
}
\examples{
x <- 1; y <- 2
cat(pp("1 + #{x} = #{1 + x}")) # "1 + 1 = 2"
cat(pp(1:3, " are numbers")) # "123 are numbers"
cat(pp(1:3, " are numbers", collapse = " and "))
# "1 and 2 and 3 are numbers"
cat(pp("x = #{x}", "y = #{y}", "x + y = #{x + y}", sep = ", "))
# x = 1, y = 2, x + y = 3
}

