% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_estim.R
\name{rc_estim}
\alias{rc_estim}
\title{Adaptive estimation of the joint density of random coefficients model in a linear random coefficient model}
\usage{
rc_estim(X, Y, b_grid, a_grid = b_grid, nbCores = 1, M_T = 60,
  N_u = 10, epsilon = (log(N)/log(log(N)))^(-2), n_0 = 0,
  trunc = 0, center = 0)
}
\arguments{
\item{X}{Vector of size $N$, $N$ being the number of observation and the number of regressors limited to 1 in this version of the package.}

\item{Y}{Outcome vector of size $N    $.}

\item{b_grid}{vector grid on which the estimator of the density of the random slope will we evaluated.}

\item{a_grid}{Vector grid on which the estimator of the density of the random intercept will we evaluated.}

\item{nbCores}{number of cores for the parallel implementation. Default is 1, no parallel computation.}

\item{M_T}{number of discretisation points for the estimated partial Fourier transform. Default is 60.}

\item{N_u}{aximal number of singular functions used in the estimation. Default is the maximum of 10 and $N_{max}$.}

\item{epsilon}{parameter for the interpolation. Default is (log(N)/log(log(N)))^(-4) as is (T5.1) in Gaillac and Gautier (2019).}

\item{n_0}{Parameter for the sample splitting. If n_0 = 0 then no sample splitting is done and we use the same sample of size $N$ to perform the estimation of the truncated density. If n_0 >0 , then this is the size of the sample used to perform the estimation of the truncated density. Default is $n_0 =0$.\\}

\item{trunc}{Dummy for the truncation of the density of the regressors to an hypercube [x_0,x_0]^p. If trunc=1, then truncation is performed and [x_0,x_0]^p is defined using the argmin of the ratio of the estimated constant c_X  over the percentage of observation in  [x_0,x_0]^p. Default is 0, no truncation.}

\item{center}{Dummy to trigger the use of X -x_bar instead of $X$ as regressor. If center=1, then use X - x_bar where x_bar is the vector of the medians coordinates by  coordinates for $X$. Default is center=0, where regressors are left unchanged.}
}
\value{
a list containing, in order:

 -  outcome : the matrix of size length(b_grid)x length(a_grid) which contains the evaluation of the estimator of the density on the grid b_grid times a_grid

 -  b_grid : vector grid on which the estimator of the density is evaluated for the random slope

 -  a_grid : vector grid on which the estimator of the density is evaluated for the random intercept

 -  x_bar : vector used to center the regressors, if center=1

 -  n_f_X : estimated supnorm of the inverse of the density of the regressors

 -  und_X : parameter x_0 used for the truncation (truncate =1) of the density of the regressors.
}
\description{
This function implements the adaptive estimation of the joint density of random coefficients model as in  Gaillac and Gautier (2019).
It takes as inputs data (Y,X) then estimates the density and return its evaluation on a grid b_grid times a_grid.
By setting nbCores greater than 1 computations are done in parallel.
}
\examples{
library(orthopolynom)
library(polynom)
library(tmvtnorm)
library(ks)
library(sfsmisc)
library(snowfall)
library(fourierin)
library(rdetools)
library(statmod)
library(RCEIM)
library(robustbase)
library(VGAM)
library(RandomCoefficients)

# beta (output) Grid
M=100
limit =7.5
b_grid  <- seq(-limit ,limit ,length.out=M)
a = limit

up =1.5
down = -up
und_beta <- a
x2 <- b_grid
x.grid <- as.matrix(expand.grid(b_grid ,b_grid ))
# DATA generating process
d = 1
Mean_mu1 = c(-2,- 3)
Mean_mu2= c(3,  0)
Sigma= diag(2, 2)
Sigma[1,2] = 1
Sigma[2,1] = 1
limit2 = 6

\dontshow{
set.seed(2019)
M=2
b_grid  <- seq(-limit ,limit ,length.out=M)
N <-5
beta <- runif(N,  -limit2,-limit2)
X <- as.matrix(runif(N,  -up,-up))
X_t <- cbind(matrix(1, N,1),X)
Y <-rowSums(beta*X_t)
out <- rc_estim(X,Y,b_grid,b_grid,nbCores = 1, M_T = 2,N_u=2)

M=100
b_grid  <- seq(-limit ,limit ,length.out=M)
}
\donttest{
N <- 1000
xi1 <- rtmvnorm(N, mean = Mean_mu1, sigma=Sigma, lower=c( -limit2,-limit2), upper=c(limit2,limit2))
xi2 <- rtmvnorm(N, mean = Mean_mu2, sigma=Sigma, lower=c( -limit2,-limit2), upper=c(limit2,limit2))
theta = runif(N, -1 , 1)
beta <- 1*(theta >=0) * xi1  + 1*(theta <0) * xi2
X <- rtmvnorm(N, mean = c(0), sigma=2.5, lower=c( down), upper=c(up))
X_t <- cbind(matrix(1, N,1),X)
Y <-rowSums(beta*X_t)
out <- rc_estim( X,Y,b_grid,b_grid,nbCores = 1, M_T = 60)
}


}
