% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{test}
\alias{test}
\title{Implementation of the RE test with possible survey weights (direct and with parallel computing)}
\usage{
test(Y_tilde, D, X = matrix(1, length(Y_tilde), 1),
  weights = rep(1/length(Y_tilde), length(Y_tilde)),
  generalized = "No", nbCores = 1, tuningParam = NULL)
}
\arguments{
\item{Y_tilde}{the vector stacking the realisations y then the anticipated values psi of respective sizes n_y and n_p.}

\item{D}{the vector stacking the dummies for the dataset of realisation : n_y ones then n_p zeros}

\item{X}{the matrix of covariates.  Set to a vector of 1 by default (in which case the test without covariates is performed).}

\item{weights}{the vector of survey weights. Uniform by default.}

\item{generalized}{whether a generalized test should be performed or not: "Add" for additive shocks (default),  "Mult" for multiplicative shocks. Set by default to "No" (no generalized test).}

\item{nbCores}{the number of cores used by the program. To reduce the computational time, this function can use several cores, in which case the library snowfall should be loaded first. By default nbCores is set to 1.}

\item{tuningParam}{a dictionnary (see the example below for modification of the default parameters) containing:

     - the parameter p  in  Section 3 of DGM.  Default is0.05.

     - epsilon the parameter epsilonon in  Section 3 of DGM. Default value is 0.05 and p is set to 0 if a generalized test is performed.

     - B the number of bootstrap samples. Default value is 500.

     - grid_y: the number of points to be tested.

       Default is quantile(Y_tilde,seq(0,1,length.out=30)).

     - c:  the parameter c inSection 3 of DGM. Default is 0.3.

     - kappa : the parameter kappapa in  Section 3 of DGM. Default is  0.001.

Default values are associated with the test without covariates.}
}
\value{
a list containing, in order:

 - N, the number of observations

 - cv01, the 1\% critical value

 - cv05, the 5\% critical value

 - cv10, the 10\% critical value

 - T_n, the Test ststistic

 - B, the number of bootstrap samples

 - p_value, the p-value

 - T_reps, the vector of bootstraped test statitics.
}
\description{
This function performs the test of rational expectations described in Section 3 of D’Haultfoeuille et al. (2018). By default, the test is implemented without covariates. To perform the test with covariates, one has to indicate in X a non-constant vector or matrix. Also, one can perform the « generalized » tests allowing for aggregate shocks by using the dummy variable generalized. Survey weights can be added. The user can modify the number of cores used by R to reduce the computational time. Tuning parameters used in the test can also be modified.
}
\examples{
## The RE test without covariates
n_p=600
n_y=n_p
N <- n_y + n_p
rho <-0.29
sig=0.1
u=1
b=0.10
a=2

psi <-rnorm(n_p,0,u)
pp_y <- runif(n_y,0,1)
zeta <- rnorm(n_y,a,sig)
zeta1 <- rnorm(n_y,-a,sig)
pp1_y <- 1*(pp_y <b)
pp2_y <- 1*(pp_y >1-b)
pp3_y <- 1*(pp_y <=(1-b) & pp_y >=b)
psi_y <-rnorm(n_y,0,u)
y =  rho*psi_y+ pp1_y*zeta + pp2_y*zeta1


D <- rbind(matrix(1,n_y,1),matrix(0,n_p,1))
Y_tilde <- rbind(matrix(y,n_y,1),matrix(psi,n_p,1))

#res <- test(Y_tilde ,D)


}
\references{
D’Haultfoeuille X, Gaillac C, Maurel A (2018). “Rationalizing Rational Expectations? Tests and Deviations.” NBER Working paper <doi:10.3386/w25274>

Andrews D, Shi X (2017). “Inference Based on Many Conditional Moment Inequalities.” Journal of Econometrics, 196(2), 275–287.

Andrews DW, Kim W, Shi X (2017). “Commands for testing conditional moment inequalities and equalities.” The Stata journal, 17(1).
}
