% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_met_recordplot.R
\name{rvn_met_recordplot}
\alias{rvn_met_recordplot}
\title{EC Climate Gauge Record Overlap Visualization}
\usage{
rvn_met_recordplot(
  metadata = NULL,
  stndata = NULL,
  variables = NULL,
  colorby = NULL
)
}
\arguments{
\item{metadata}{tibble of the station meta-data from \code{weathercan::stations_search()}}

\item{stndata}{tibble of the station data from \code{weathercan::weather_dl()}}

\item{variables}{if using \code{weathercan::weather_dl()}, column names for variables of interest (currently only accepts 1 per call)}

\item{colorby}{column name by which to color station records. Set to 'elev' (elevation) by default. Can be set to
"dist" (distance from coordinates of interest) if supplying \code{weathercan::stations_search} results.}
}
\value{
returns a 2x1 plot object containing 2 ggplot objects
  \item{top:}{A chronological horizontal bar plot depicting each station's record period}
  \item{bottom:}{A vertical bar plot depicting the number of station records available each year}
}
\description{
This function plots the length of Environment Canada climate station records,
accessed via the \pkg{weathercan} package, to identify periods in which multiple
station records overlap.
}
\details{
Accepts outputs from either the \code{stations_search()} or \code{weather_dl()} functions
from the \pkg{weathercan} package and extracts the start and end dates of the record
from each station for plotting.

Station records are plotted chronologically on a timeline, and can be colored
according to either the station's elevation (default, works for both types of inputs)
or the station's distance from a point of interest (works only when supplying
\code{stations_search()} results as metadata input).

The timeline plot is accompanied by a bar plot counting the number of stations with
available data year by year.

Large differences in elevation between stations may point towards consideration for
the effect of lapse rates on climate forcings driving a model response.
}
\examples{
# load metadata from RavenR sample data
data(rvn_weathercan_metadata_sample)

## code that would be used to download metadata using weathercan
# library(weathercan)
#
# metadata = stations_search(coords=c(50.109,-120.787),
#    dist=150, # EC stations 150 km of Merritt, BC
#   interval='day'
# )
# metadata = metadata[metadata$start>=2000,] # subset stations with recent data
# metadata = metadata[1:3,] # take only the first 3 stations for brevity

# plot line colours by station elevation
rvn_met_recordplot(metadata=rvn_weathercan_metadata_sample, colorby='elev')

# plot line colours by distance to specified co-ordinates
rvn_met_recordplot(metadata=rvn_weathercan_metadata_sample, colorby='distance')

## load sample weathercan::weather_dl() with single station
data(rvn_weathercan_sample)

# compare records for a specific variable
rvn_met_recordplot(stndata=rvn_weathercan_sample, variables = "total_precip")

}
