% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{RblRequestBuilder}
\alias{RblRequestBuilder}
\title{Build a request file to query Bloomberg}
\usage{
RblRequestBuilder(header, fields, identifiers, overrides = NULL)
}
\arguments{
\item{header}{names list of headers. Ex. list(FIRMNAME = RblUser(), PROGRAMNAME = 'getdata')}

\item{fields}{vector of Bloomberg fields. Ex. c('PX_LAST', 'PX_OPEN', 'PX_HIGH', 'PX_LOW')}

\item{identifiers}{vector of Bloomberg identifiers. Ex c('SXXE Index', 'SX5E Index')}

\item{overrides}{named list of Bloomberg overrides. Ex list('END_DT' = '20100101')}
}
\value{
character string representing the request file. Upload it to query Bloomberg (see \code{\link{RblUpload}})
}
\description{
The request file is generated according to Bloomberg Data License documentation
}
\examples{
\dontrun{
# Run RblConnect first
RblRequest <- RblRequestBuilder(header = list(FIRMNAME = RblUser(), PROGRAMNAME = 'getdata'), 
                                fields = c('PX_LAST'), identifiers = c('SXXE Index'))
RblRequest
}

}
