% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsrch.R
\name{bsrch}
\alias{bsrch}
\title{Run 'Bloomberg SRCH' Queries}
\usage{
bsrch(domain, limit = "", verbose = FALSE, con = defaultConnection())
}
\arguments{
\item{domain}{A character string with the name of the domain
to execute.  It can be a user defined SRCH screen, commodity
screen or one of the variety of Bloomberg examples. All domains
are in the format <domain>:<search_name>.}

\item{limit}{A character string containing a value by which to
limit the search length -- NOT YET IMPLEMENTED}

\item{verbose}{A boolean indicating whether verbose operation is
desired, defaults to \sQuote{FALSE}.}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function
\code{defaultConnection}.}
}
\value{
A data frame object with the requested SRCH data.
}
\description{
This function uses the Bloomberg API to retrieve 'bsrcb' (Bloomberg
SRCH Data) queries
}
\note{
There are two main domains used for bsrch. The COMDTY domain
requires additional parameters and is not supported. The FI domain
works on user-defined searches accessed via SRCH.
}
\examples{
\dontrun{
head(bsrch("FI:SRCHEX.@CLOSUB"), 20)
}
}
\author{
Morgan Williams and Dirk Eddelbuettel
}
