% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiger_cbsa_sf.R
\name{tiger_cbsa_sf}
\alias{tiger_cbsa_sf}
\title{tiger_cbsa_sf}
\usage{
tiger_cbsa_sf(
  output_dir = tempdir(),
  delete_files = TRUE,
  vintage = 2020,
  general = FALSE,
  resol = "500k",
  set_crs = NULL,
  transform_crs = NULL,
  sf_info = FALSE,
  do_progress = FALSE,
  shapefile = NULL,
  datafile = NULL,
  datafile_key = NULL,
  sf_key = "GEOID",
  state_filter = NULL,
  city_filter = NULL,
  check_na = FALSE
)
}
\arguments{
\item{output_dir}{A full directory path where the shapefile and its associated files will be downloaded.
The default is the directory defined by the value returned by \code{tempdir()}.}

\item{delete_files}{A logical which if \code{TRUE} will delete the shapefile and associated files in 'output_dir'.
The default is \code{TRUE}.}

\item{vintage}{A numeric that sets the vintage of interest. The default is 2020.}

\item{general}{A logical which if \code{TRUE} will download a less detailed, more generalized version of the state geometries.}

\item{resol}{If 'general' is \code{TRUE}, then the resolution to return. Acceptable values are strings
"500k", "5m", "20m".}

\item{set_crs}{A numeric or character string which if non-NULL calls sf::st_crs() to set the crs of the geometries and transforms them.}

\item{transform_crs}{A numeric or character string which if non-NULL calls sf::st_transform()
to perform a crs transform of the geometries. Note that the crs of the shapefile must not be NA.}

\item{sf_info}{A logical which if \code{TRUE} displays info on the resulting simple feature object.}

\item{do_progress}{A logical which if \code{TRUE} displays a progress bar during the download.}

\item{shapefile}{A full file path to a shapefile folder with its unzipped files to be processed instead of downloading.}

\item{datafile}{A dataframe containing data that should be joined with this function's resultant simple feature object.}

\item{datafile_key}{The column name from 'datafile' dataframe used to key with the 'sf_key' column of the resultant simple feature dataframe.}

\item{sf_key}{The column from the resultant dataframe used to key with the 'datafile' dataframe.}

\item{state_filter}{A string that filters the resultant sf by a state name (e.g. "TX") .}

\item{city_filter}{A string that filters the resultant sf by a city name (e.g. "Kansas City").}

\item{check_na}{A logical which if \code{TRUE} will remove rows that have missing values for any of the columns.
The default is to not check the columns for \code{NA} values.}
}
\value{
A data frame object of class sf
}
\description{
This function performs three tasks:
\enumerate{
\item Download to an output directory a zip file from the TIGER/Line Shapefiles database.
\item Unzip the zip file and locate the shape file of interest.
\item Read and convert the shape file to a simple feature object.
}
}
\details{
Returns simple feature (sf) of core based statistical area (CBSA) boundary related geometric polygons,
provided by the US Census Bureau's TIGER/Line Shapefiles database. See
\href{https://r-spatial.github.io/sf/articles/sf1.html}{Simple Features for R}
for more information on simple features.

A more generalized, recognizable version of the CBSA geometries that has less download size is also available.  For more information on cartographic boundary files see
\href{https://www.census.gov/programs-surveys/geography/technical-documentation/naming-convention/cartographic-boundary-file.html}{Cartographic Boundary File Description}.
These files are available for vintages greater than 2009 with resolution 1:500k, 1:5m, 1:20m meters.
For descriptive information on CBSA see \href{https://www.census.gov/programs-surveys/metro-micro/about.html}{About}.

The function returns the simple feature object which can easily be mapped (see \href{https://github.com/deandevl/RplotterPkg}{RplotterPkg::create_sf_plot()}) or
joined with US Census Bureau demographic data. To help incorporate data files, this function
has a 'datafile' parameter which will be joined with the resultant simple feature object. The only
requirement is that a common "key" for joining exist between the data dataframe and the simple feature dataframe.
}
\examples{
library(httr)
library(sf)
library(data.table)
library(withr)
library(RcensusPkg)

# Define a temporary, self deleting output folder for the downloaded shapefiles
output_dir <- withr::local_tempdir()
if(!dir.exists(output_dir)){
  dir.create(output_dir)
}

# Get shapefile geometries for the Core-based statistical areas
#   of Texas with vintage 2020.
# Note that there is also a city filter parameter (city_filter).
cbsa_tx_sf <- RcensusPkg::tiger_cbsa_sf(
  vintage = 2020,
  resol = "20m",
  # city_filter = "Kansas City",
  state_filter = "TX",
  general = TRUE,
  output_dir = output_dir,
  delete_files = FALSE
)

}
