% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivpml.R
\name{ivpml}
\alias{ivpml}
\alias{terms.ivpml}
\alias{model.matrix.ivpml}
\alias{estfun.ivpml}
\alias{bread.ivpml}
\alias{vcov.ivpml}
\alias{df.residual.ivpml}
\alias{coef.ivpml}
\alias{logLik.ivpml}
\alias{print.ivpml}
\alias{summary.ivpml}
\alias{print.summary.ivpml}
\alias{predict.ivpml}
\title{Estimate Instrumental Variable Probit model by Maximum Likelihood.}
\usage{
ivpml(formula, data, messages = TRUE, ...)

\method{terms}{ivpml}(x, ...)

\method{model.matrix}{ivpml}(object, ...)

\method{estfun}{ivpml}(x, ...)

\method{bread}{ivpml}(x, ...)

\method{vcov}{ivpml}(object, ...)

\method{df.residual}{ivpml}(object, ...)

\method{coef}{ivpml}(object, ...)

\method{logLik}{ivpml}(object, ...)

\method{print}{ivpml}(x, ...)

\method{summary}{ivpml}(object, eigentol = 1e-12, ...)

\method{print}{summary.ivpml}(x, digits = max(3, getOption("digits") - 2), ...)

\method{predict}{ivpml}(object, newdata = NULL, type = c("xb", "pr", "stdp"), asf = TRUE, ...)
}
\arguments{
\item{formula}{a symbolic description of the model of the form \code{y ~ x | z} where \code{y} is the binary dependent variable, \code{x} includes the exogenous and the endogenous continuous variable, and \code{z} is the complete set of instruments.}

\item{data}{the data of class \code{data.frame}.}

\item{messages}{if \code{TRUE}, then additional messages for the estimation procedure are displayed.}

\item{...}{arguments passed to \code{maxLik}.}

\item{x, object}{an object of class \code{ivpml}.}

\item{eigentol}{the standard errors are only calculated if the ratio of the smallest and largest eigenvalue of the Hessian matrix is less than \code{eigentol}.  Otherwise the Hessian is treated as singular.}

\item{digits}{the number of digits.}

\item{newdata}{optionally, a data frame in which to look for variables with which to predict.}

\item{type}{the type of prediction required. The default, \code{type = xb}, is on the linear prediction. If \code{type = pr}, the predicted probabilities of a positive outcome is returned. Finally, if \code{type = stdp} the standard errors of the linear predictions for each individual is returned.}

\item{asf}{if \code{TRUE}, the average structural function is used. This option is not allowed with \code{xb} or \code{stdp}.}
}
\description{
Estimation of Probit model with one endogenous and continuous variable by Maximum Likelihood.
}
\details{
The IV probit for cross-sectional data has the following structure:

\deqn{
y_{1i}^*  = x_i^\top\beta + \gamma y_{2i}+ \epsilon_i,
}
with
\deqn{
 y_{2i}  = z_i^\top\delta +  \upsilon_i,   
}
where \eqn{y_{1i}^*} is the latent (unobserved) dependent variable for individual \eqn{i = 1,...,N}; 
\eqn{y_{2i}} is the endogenous continuous variable; \eqn{z_i} is the vector of exogenous variables 
which also includes the instruments for \eqn{y_{2i}}; 
and \eqn{(\epsilon, \upsilon)} are normal jointly distributed.

The model is estimated using the \code{maxLik} function from \code{\link[maxLik]{maxLik}} package using 
analytic gradient.
}
\examples{
\donttest{ 
# Data
library("AER")
data("PSID1976")
PSID1976$lfp  <- as.numeric(PSID1976$participation == "yes")
PSID1976$kids <- with(PSID1976, factor((youngkids + oldkids) > 0,
                                      levels = c(FALSE, TRUE), 
                                      labels = c("no", "yes")))
                                      
# IV probit model by MLE
# (nwincome is endogenous and heducation is the additional instrument)
PSID1976$nwincome <- with(PSID1976, (fincome - hours * wage)/1000)
fiml.probit <- ivpml(lfp ~  education + experience + I(experience^2) + age + 
                            youngkids + oldkids + nwincome |
                            education + experience + I(experience^2) + age + 
                            youngkids + oldkids + heducation, 
                     data = PSID1976)
summary(fiml.probit)
}
}
\references{
Greene, W. H. (2012). Econometric Analysis. 7 edition. Prentice Hall.
}
\author{
Mauricio Sarrias.
}
\keyword{models}
