% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCompute.R
\name{computeSpectralEmbeddingSample}
\alias{computeSpectralEmbeddingSample}
\title{Spectral embedding}
\usage{
computeSpectralEmbeddingSample(data.sample, use.sampling = FALSE,
  sampling.size.max = 0, scale = FALSE, selected.var = NULL,
  echo = F, RclusTool.env = initParameters())
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{use.sampling}{boolean: if FALSE (default), data sampling is not used.}

\item{sampling.size.max}{numeric: maximal size of the sampling set.}

\item{scale}{boolean, if FALSE (default), data scaling is not used.}

\item{selected.var}{vector of features names to consider for the spectral embedding.}

\item{echo}{boolean: if FALSE (default), no description printed in the console.}

\item{RclusTool.env}{environment in which all global parameters, raw data and results are stored.}
}
\value{
features list containing the results of spectral embedding, returned by spectralEmbeddingNg.
}
\description{
Perform spectral embedding for non-linear dimensionality reduction.
}
\details{
computeSpectralEmbeddingSample performs Spectral embedding for non-linear dimensionality reduction
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")
x <- importSample(file.features=tf, dir.save=tempdir())

res <- computeSpectralEmbeddingSample(x)

plot(res$x[,1], res$x[,2], main="Spectral Embedding", xlab="SC1", ylab="SC2")


}
\seealso{
\code{\link{computePcaSample}}
}
\keyword{internal}
