% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleBuilding.R
\name{loadSample}
\alias{loadSample}
\title{Sample loading}
\usage{
loadSample(file.RDS, RclusTool.env = initParameters(),
  file.config = "")
}
\arguments{
\item{file.RDS}{character vector for the name of the .RDS file where built data.sample object is saved.}

\item{RclusTool.env}{environment in which all global parameters, raw data and results are stored.}

\item{file.config}{character vector for the name of the configuration file.}
}
\value{
data.sample loaded data.sample.
}
\description{
Load and preprocess sample.
}
\details{
loadSample reads RDS sample file; sample is preprocessed by call to function preprocessSample()
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")

x <- importSample(tf, dir.save=tempdir())

res <- loadSample(file.path(getwd(), x$files$RDS))       


}
\seealso{
\code{\link{importSample}}
}
\keyword{internal}
