% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeSpectral.R
\name{spectralClustering}
\alias{spectralClustering}
\title{Spectral clustering}
\usage{
spectralClustering(sim, K, nruns = 1, test.dim = FALSE,
  projection = "Ng", post.norm = "sphere", clustering = "kmeans",
  max.dim = 30, add.1 = FALSE)
}
\arguments{
\item{sim}{similarity matrix.}

\item{K}{number of clusters.}

\item{nruns}{number of random sets.}

\item{test.dim}{boolean, only used to test dimensions (setting the number of left singular vectors to be computed).}

\item{projection}{character: final data projection. Must be 'Ng' (default), 'LPP', or 'AFC'.}

\item{post.norm}{character: final data normalization. Must be 'sphere' (default) or 'Shi'.}

\item{clustering}{character: clustering method in the spectral space. Must be 'kmeans' (default) or 'pam'.}

\item{max.dim}{maximal number of dimensions for the computation of left sigular vectors.}

\item{add.1}{boolean : if TRUE add a column to the matrix containing the eigenvectors of the similarity matrix equal to 1/sqrt(nrow(similarity matrix))}
}
\value{
The function returns a list containing:
\item{label}{vector of labels.}
\item{medoids}{matrix of cluster centers in the space of the K first normalized eigenvectors.}
\item{id.med}{vector containing the medoids indices.}
\item{x}{matrix containing, in columns, the eigenvectors of the similarity matrix.}
\item{eigen.val}{vector containing the eigenvalues of the similarity matrix.}
\item{cluster.info}{some statistics on each cluster.}
\item{ncp}{number of left singular vectors computed.}
}
\description{
Perform spectral clustering thanks to a similarity matrix.
}
\details{
spectralClustering returns a partition obtained by spectral clustering
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))

sim <- computeGaussianSimilarity(dat, 1)
res <- spectralClustering(sim, K=3)

plot(dat[,1], dat[,2], type = "p", xlab = "x", ylab = "y", 
col = res$label, main = "Initial features space")
plot(res$x[,1], res$x[,2], type = "p", xlab = "2nd eigenvector", 
	ylab = "3rd eigenvector", col = res$label, main = "Spectral embedding")

}
\references{
A. Ng, M. Jordan, Y. Weiss, On spectral clustering: Analysis and an algorithm, Neural Inf. Process. Systems NIPS14 (2002), pp. 849-856.
}
\seealso{
\code{\link{spectralClusteringNg}}
}
\keyword{internal}
