% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb_flag.R
\name{cdb_flag}
\alias{cdb_flag}
\title{Flag potential issues in matrices of a COM(P)ADRE database}
\usage{
cdb_flag(
  cdb,
  checks = c("check_NA_A", "check_NA_U", "check_NA_F", "check_NA_C", "check_zero_U",
    "check_singular_U", "check_component_sum", "check_ergodic", "check_irreducible",
    "check_primitive", "check_surv_gte_1")
)
}
\arguments{
\item{cdb}{A CompadreDB object}

\item{checks}{Character vector specifying which checks to run.

  Defaults to all, i.e. \code{c("check_NA_A", "check_NA_U", "check_NA_F",
  "check_NA_C", "check_zero_U", "check_singular_U", "check_component_sum",
  "check_ergodic", "check_irreducible", "check_primitive", "check_surv_gte_1")}}
}
\value{
Returns \code{cdb} with extra columns appended to the data slot
  (columns have the same names as the corresponding elements of
  \code{checks}) to indicate (TRUE/FALSE) whether there are potential
  problems with the matrices corresponding to a given row of the data.
}
\description{
Adds columns to the data slot of a CompadreDB object that flag potential
problems in the matrix population models. These columns can subsequently be
used to subset the database by logical argument.

Optional checks include:
\itemize{
  \item \code{check_NA_A}: missing values in matA?
  \item \code{check_NA_U}: missing values in matU?
  \item \code{check_NA_F}: missing values in matF?
  \item \code{check_NA_C}: missing values in matC?
  \item \code{check_zero_U}: matU all zeros (including NA)?
  \item \code{check_singular_U}: matU singular (i.e. non-invertable)?
  \item \code{check_component_sum}: do matU/matF/matC components sum to matA
    (see \emph{Details})?
  \item \code{check_ergodic}: is matA ergodic (see
    \code{\link[popdemo]{isErgodic}})?
  \item \code{check_irreducible}: is matA irreducible (see
    \code{\link[popdemo]{isIrreducible}})?
  \item \code{check_primitive}: is matA primitive (see
    \code{\link[popdemo]{isPrimitive}})?
  \item \code{check_surv_gte_1}: does matU contains values that are equal to or greater than 1?
}
}
\details{
For the flag \code{check_component_sum}, a value of \code{NA} will be
returned if the matrix sum of matU, matF, and matC consists only of zeros
and/or \code{NA}, indicating that the matrix has not been split.
}
\examples{
CompadreFlag <- cdb_flag(Compadre)

# only check whether matA has missing values, and whether matA is ergodic
CompadreFlag <- cdb_flag(Compadre, checks = c("check_NA_A", "check_ergodic"))

}
\seealso{
Other data checking: 
\code{\link{cdb_check_species}()},
\code{\link{cdb_collapse}()},
\code{\link{cdb_compare}()},
\code{\link{mpm_methods}}
}
\author{
Owen Jones <jones@biology.sdu.dk>

Julia Jones <juliajones@biology.sdu.dk>

Roberto Salguero-Gomez <rob.salguero@zoo.ox.ac.uk>

Danny Buss <dlb50@cam.ac.uk>

Patrick Barks <patrick.barks@gmail.com>
}
\concept{data checking}
