% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb_id.R
\name{cdb_id}
\alias{cdb_id}
\title{Create integer identifiers for a COM(P)ADRE database corresponding to unique
combinations of a given set of columns}
\usage{
cdb_id(cdb, columns)
}
\arguments{
\item{cdb}{A CompadreDB object}

\item{columns}{Vector of column names from which unique combinations should
be identified}
}
\value{
Vector of integer identifiers corresponding to the rows of
  \code{cdb}, based on unique combinations of the elements in \code{columns}.
}
\description{
Creates a vector of integer identifiers corresponding to the rows of a
CompadreDB object, based on unique combinations of the elements in a given
set of columns.
}
\details{
Identifiers are assigned by pasting together the relevant columns, assigning
factor levels based on alphabetical order, and then converting the factor
levels to integers.
}
\examples{
cdb_id(Compadre, columns = c("SpeciesAuthor", "MatrixTreatment"))

}
\seealso{
Other data management: 
\code{\link{cdb_flatten}()},
\code{\link{cdb_id_stages}()},
\code{\link{cdb_id_studies}()},
\code{\link{cdb_mean_matF}()},
\code{\link{cdb_rbind}()},
\code{\link{cdb_unflatten}()},
\code{\link{cdb_unnest}()},
\code{\link{mpm_mean}()},
\code{\link{string_representation}}
}
\author{
Patrick Barks <patrick.barks@gmail.com>
}
\concept{data management}
