% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cToPOSIXct}
\alias{cToPOSIXct}
\title{Parse POSIXct objects from character variables}
\usage{
cToPOSIXct(sv, fmt = "\%Y-\%m-\%d \%H:\%M:\%OS", tz = "UTC")
}
\arguments{
\item{sv}{A vector of type character with datetime expressions
in ISO format to be parsed and converted.}

\item{fmt}{A format, defaults to the ISO format if unset}

\item{tz}{A string with the timezone, defaults to \sQuote{UTC} if unset}
}
\value{
A vector of \sQuote{POSIXct} elements.
}
\description{
This function uses Rcpp to parse
datetimes from strings. It returns a vector of \code{POSIXct}
objects. These represent dates and time as (possibly
fractional) seconds since the \sQuote{epoch} of January 1, 1970.
A timezone can be set, if none is supplied \sQuote{UTC} is set.
}
\details{
The default standard ISO format \sQuote{YYYY-MM-DD HH:MM:SS.FFFFFFF} is
is used by default along with the UTC time zone.

This function is for comparison only.
}
\examples{
times <- c("2004-03-21 12:45:33.123456",
          "2004-03-21 12:45:34")
cToPOSIXct(times)
}
\seealso{
\code{\link{Rcpp}}
}
\author{
Dirk Eddelbuettel
}
