% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{toTz}
\alias{toTz}
\title{Return difference between two time zones at a given date.}
\usage{
toTz(dt, tzfrom, tzto, verbose = FALSE)
}
\arguments{
\item{dt}{A Datetime object specifying when the difference is to be computed.}

\item{tzfrom}{The first time zone as a character vector.}

\item{tzto}{The second time zone as a character vector.}

\item{verbose}{A boolean toggle indicating whether more verbose operations
are desired, default is \code{FALSE}.}
}
\value{
A Datetime object with the given (civil time) determined by the
incoming object (and its timezone) shifted to the target timezone.
}
\description{
Change from one given timezone to another.
}
\details{
Time zone offsets vary by date, and this helper function converts
a Datetime object from one given timezone to another.
}
\examples{
toTz(Sys.time(), "America/New_York", "Europe/London")
}
\author{
Dirk Eddelbuettel
}

