% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxiliaryFunctions_USER.R
\name{predict.sclm}
\alias{predict.sclm}
\title{Prediction in Spatial Model with censored/missing responses}
\usage{
\method{predict}{sclm}(object, locPre, xPre, ...)
}
\arguments{
\item{object}{object of class '\code{sclm}' given as output of \code{\link{EM.sclm}}, \code{\link{SAEM.sclm}}
or \code{\link{MCEM.sclm}} function.}

\item{locPre}{matrix of coordinates for which prediction is performed.}

\item{xPre}{matrix of covariates for which prediction is performed.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The function returns a data frame with:
\item{xcoord}{x coordinates.}
\item{ycoord}{y coordinates.}
\item{predValues}{predicted values.}
\item{sdPred}{predicted standard deviations.}
}
\description{
This function performs spatial prediction in a set of new \code{S} spatial locations.
}
\details{
This function predicts using the Mean Squared Error (MSE) criterion, which takes the conditional
expectation E(Y|X) as the best linear predictor.
}
\examples{
\donttest{
n = 120
set.seed(1000)
coords = round(matrix(runif(2*n,0,15),n,2),5)
x = cbind(rbinom(n,1,0.50), rnorm(n), rnorm(n))
data = rCensSp(c(1,4,-1),2,3,0.50,x,coords,"left",0.10,20,"exponential",0)

# Estimation
data1 = data$TrainingData
# EM algorithm
fit1 = EM.sclm(y=data1$yobs, x=data1[,7:9], cens=data1$cens,LI=data1$LI,
             LS=data1$LS, coords=data1[,5:6], init.phi=2.50, init.nugget=1,
             type="exponential", show.SE=TRUE, error=1e-4)
# SAEM algorithm
fit2 = SAEM.sclm(y=data1$yobs,x=data1[,7:9],cens=data1$cens,LI=data1$LI,
             LS=data1$LS, coords=data1[,5:6], init.phi=2.50, init.nugget=1,
             type="exponential", show.SE=TRUE, error=1e-4)
# MCEM algorithm
fit3 = MCEM.sclm(y=data1$yobs,x=data1[,7:9],cens=data1$cens,LI=data1$LI,
             LS=data1$LS, coords=data1[,5:6], init.phi=2.50, init.nugget=1,
             type="exponential", MaxIter=300, show.SE=TRUE, error=1e-4)
c(fit1$theta)
c(fit2$theta)
c(fit3$theta)

# Prediction
data2 = data$TestData
pred1 = predict(fit1, data2[,2:3], data2[,4:6])
pred2 = predict(fit2, data2[,2:3], data2[,4:6])
pred3 = predict(fit3, data2[,2:3], data2[,4:6])

# Cross-validation
mean((data2$yobs - pred1$predValues)^2)
mean((data2$yobs - pred2$predValues)^2)
mean((data2$yobs - pred3$predValues)^2)}
}
\seealso{
\code{\link{EM.sclm}}, \code{\link{SAEM.sclm}}, \code{\link{MCEM.sclm}}
}
\author{
Katherine L. Valeriano, Alejandro Ordonez, Christian E. Galarza and Larissa A. Matos.
}
