% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsluv.R
\name{hsl}
\alias{hsl}
\title{HSL color specification}
\usage{
hsl(h = 360, s = 100, l = 100, alpha = NULL)
}
\arguments{
\item{h}{the hue, a number between \code{0} and \code{360}}

\item{s}{the saturation, a number between \code{0} and \code{100}}

\item{l}{the lightness, a number between \code{0} and \code{100}}

\item{alpha}{opacity, a number between \code{0} and \code{1}, 
or \code{NULL}}
}
\value{
The \code{hsl} function returns a hexadecimal string representing 
  the corresponding color.
}
\description{
Converts a color given in HSL coordinates to a hexadecimal 
  string
}
\examples{
saturation <- 100
f <- Vectorize(
  function(x, y){
    z <- complex(real = x, imaginary = y)
    modulus <- Mod(z)
    if(modulus > 1){
      return("#ffffff")
    }
    radians <- Arg(z)
    if(radians < 0){
      radians <- radians + 2*pi
    }
    degrees <- 360 * radians / 2 / pi
    hsl(h = degrees, s = saturation, l = 100*modulus)
  }
)

x <- y <- seq(-1, 1, length.out = 200L)
image <- outer(x, y, f)

opar <- par(mar = c(0, 0, 0, 0))
plot(NULL, xlim = c(-1, 1), ylim = c(-1, 1), asp = 1)
rasterImage(image, -1, -1, 1, 1)
par(opar)
}
