% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{xlogistic_fits}
\alias{xlogistic_fits}
\title{Out of sample logistic predictions (in link space).}
\usage{
xlogistic_fits(x, y, w, i, j)
}
\arguments{
\item{x}{NumericVector, expanatory variable.}

\item{y}{NumericVector, 0/1 values to fit.}

\item{w}{NumericVector, weights (required, positive).}

\item{i}{integer, first index (inclusive).}

\item{j}{integer, last index (inclusive).}
}
\value{
vector of predictions for interval.
}
\description{
1-hold out logistic regression predections.
Zero indexed.
}
\examples{

set.seed(5)
d <- data.frame(x = rnorm(10))
d$y <- d$x + rnorm(nrow(d))>0
weights <- runif(nrow(d))
m <- glm(y~x, data = d, family = binomial, weights = weights)
d$pred1 <- predict(m, newdata = d, type = "link")
d$pred2 <- xlogistic_fits(d$x, d$y, weights, 0, nrow(d)-1)
d <- d[order(d$x), , drop = FALSE]
print(d)

}
\keyword{internal}
