% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{solve_interval_partition_k}
\alias{solve_interval_partition_k}
\title{solve_interval_partition interval partition problem with a bound on number of steps.}
\usage{
solve_interval_partition_k(x, kmax)
}
\arguments{
\item{x}{square NumericMatix, for j>=i x(i,j) is the cost of partition element [i,...,j] (inclusive).}

\item{kmax}{int, maximum number of segments in solution.}
}
\value{
dynamic program solution.
}
\description{
Solve a for a minimal cost partition of the integers [1,...,nrow(x)] problem where for j>=i x(i,j).
is the cost of choosing the partition element [i,...,j]. 
Returned solution is an ordered vector v of length k<=kmax where: v[1]==1, v[k]==nrow(x)+1, and the 
partition is of the form [v[i], v[i+1]) (intervals open on the right).
}
\examples{

costs <- matrix(c(1.5, NA ,NA ,1 ,0 , NA, 5, -1, 1), nrow = 3)
solve_interval_partition(costs, nrow(costs))

}
