\name{evaluation}
\alias{evaluation}

\title{
Observed sequence evaluation given a model
}

\description{
This function computes the log-likelihood of an observed sequence being generated by a hidden Markov model with fixed parameters.
}

\usage{
evaluation(hmm , sequence , method = "f" )
}

\arguments{
  \item{hmm}{a list that contains all the necesary variables to define a hidden Markov model.}
  \item{sequence}{a vector that contains a sequence of observations to be evaluated.}
  \item{method}{method especified to do the evaluation}
}

\details{
The methods to be selected can be "f" for the forward algorithm and "b" for the backward algorithm.
}

\value{
A value that represents the log likelihood of the sequence given the hiddden Markov model.
}

\references{
Cited references are listed on the \link{RcppHMM} manual page.
}


\seealso{
\code{\link{generateObservations}} , \code{\link{verifyModel}} , \code{\link{loglikelihood}}
}

\examples{
# Set the model parameters
n <- c("First","Second")
m <- c("A","T","C","G")
A <- matrix(c(0.8,0.2,
              0.1,0.9),
            nrow = 2,
            byrow = TRUE)

B <- matrix(c(0.2, 0.2, 0.3, 0.3,
              0.4, 0.4, 0.1, 0.1),
            nrow = 2,
            byrow = TRUE)

Pi <- c(0.5, 0.5)

params <- list( "Model" = "HMM",
                "StateNames" = n,
                "ObservationNames" = m,
                "A" = A,
                "B" = B,
                "Pi" = Pi)

HMM <- verifyModel(params)

# Data simulation
set.seed(100)
length <- 100
observationSequence <- generateObservations(HMM, length)

#Sequence evaluation
evaluation(HMM, observationSequence$Y)
evaluation(HMM, observationSequence$Y, "b")
}

\keyword{methods}
