.getLibs <- function() {
    linker_pattern <- "gcc|clang|g\\+\\+"

    shlib_ld <- system(paste0(file.path(R.home("bin"), "R"),
        " CMD config SHLIB_LD"), intern=TRUE)
    shlib_cxxld <- system(paste0(file.path(R.home("bin"), "R"),
        " CMD config SHLIB_CXXLD"), intern=TRUE)

    shlib_ld_good <- FALSE
    shlib_cxxld_good <- FALSE
    
    if (shlib_ld != "") {
        shlib_ld_good <- tryCatch({
            shlib_ld_results <- system(paste0(shlib_ld, " --version"), intern=TRUE)
            
            if (any(grepl(linker_pattern, shlib_ld_results))) {
                shlib_ld_prog <- system(paste0(shlib_ld, " --print-prog-name=ld"), intern=TRUE)
                shlib_ld_results <- system(paste0(shlib_ld_prog, " --version"), intern=TRUE)
                
                shlib_ld_good <- (grepl("^GNU (ld|gold)", shlib_ld_results[1]))
            } else {
                shlib_ld_good <- FALSE
            }
            
            shlib_ld_good
        }, warning = function(w) {
            return(FALSE)
        }, error = function(e) {
            return(FALSE)
        })
    } else {
        shlib_ld_good <- TRUE
    }
    
    if (shlib_cxxld != "") {
        shlib_cxxld_good <- tryCatch({
            shlib_cxxld_results <- system(paste0(shlib_cxxld, " --version"), intern=TRUE)
            
            if (any(grepl(linker_pattern, shlib_cxxld_results))) {
                shlib_cxxld_prog <- system(paste0(shlib_cxxld, " --print-prog-name=ld"), intern=TRUE)
                shlib_cxxld_results <- system(paste0(shlib_cxxld_prog, " --version"), intern=TRUE)
                
                shlib_cxxld_good <- (grepl("^GNU (ld|gold)", shlib_cxxld_results[1]))
            } else {
                shlib_cxxld_good <- FALSE
            }
            
            shlib_cxxld_good
        }, warning = function(w) {
            return(FALSE)
        }, error = function(e) {
            return(FALSE)
        })
    } else {
        shlib_cxxld_good <- TRUE
    }

    libs <- if (shlib_ld_good && shlib_cxxld_good) "-Wl,-S" else ""

    libs
}

inlineCxxPlugin <- Rcpp:::Rcpp.plugin.maker(libs = .getLibs())
