% Generated by roxygen2 (4.1.1): do not edit by hand
\name{o_rpois}
\alias{o_rpois}
\title{Drawing from R Poisson Distribution in Octave}
\usage{
o_rpois(n, p = n, lambda)
}
\arguments{
  \item{n}{number of output rows}

  \item{p}{number of output columns (default to \code{n})}

  \item{lambda}{Mean of the Poisson distribution}
}
\description{
  This function wraps a call to the standard Octave function \code{randp},
which is redefined by \code{RcppOctave} to call the R base function
\code{\link[stats]{rpois}}.
This enables to exactly reproduce stochastic computations in R and Octave,
without changing the original Octave/Matlab code.
See \code{\link{o_runif}} for more details.
}
\details{
  This function calls the Octave function \code{randp} as provided by
\code{RcppOctave}, which returns the draws as double.
The result is converted into integer to match the behaviour of
\code{\link{rpois}}
}
\section{Octave Documentation for \emph{randp}}{

\Sexpr[results=rd,stage=render]{if( .Platform$OS.type != 'windows' || .Platform$r_arch != 'x64' ) RcppOctave::o_help(randp, format='rd')}

\emph{[Generated from Octave-\Sexpr{RcppOctave::o_version()} on \Sexpr{Sys.time()}]}
}
\examples{
\dontshow{# roxygen generated flag
options(R_CHECK_RUNNING_EXAMPLES_=TRUE)
}

# Draw random poisson values (in vector form)
set.seed(123)
o_rpois(1, lambda = 4)
o_rpois(1, 10, 4)

# Draw random poisson values (in matrix form)
set.seed(123)
o_rpois(2, lambda = 4)
o_rpois(2, 5, lambda = 4)
}
\seealso{
  rpois

Other orandom: \code{\link{o_rexp}};
  \code{\link{o_rgamma}}; \code{\link{o_rnorm}};
  \code{\link{o_runif}}
}

