% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcssGet.R
\name{RcssValue}
\alias{RcssValue}
\title{Extracts a value from an Rcss object}
\usage{
RcssValue(selector, property, default = NULL, Rcssclass = NULL,
  Rcss = "default")
}
\arguments{
\item{selector}{character, name of selector, e.g. 'points'}

\item{property}{character, name of property to get, e.g. 'col'}

\item{default}{value to return if selector/property are not defined}

\item{Rcssclass}{character or vector, subclass in Rcss}

\item{Rcss}{Rcss object}
}
\description{
If the selector and property are defined in the Rcss object,
this function will return the value stored in the Rcss object.
Otherwise, the function will return a default value.
See also related functions RcssGetPropertyValueOrDefault, which
is the same, except that RcssValue is shorter to write and takes
the Rcss object as its last argument.
}
