% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_PLP.R
\name{do.plp}
\alias{do.plp}
\title{Piecewise Laplacian-based Projection (PLP)}
\usage{
do.plp(X, ndim = 2, preprocess = "null", type = c("proportion", 0.2))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null" and three options of "center", "decorrelate", or "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
\code{do.plp} is an implementation of Piecewise Laplacian-based Projection (PLP) that
adopts two-stage reduction scheme with local approximation.
}
\details{
First step is to select \eqn{\sqrt{n}} number of control points using \eqn{k}-means algorithm.
After selecting control points that play similar roles as representatives of the entire data points,
it performs classical multidimensional scaling.

For the rest of the data other than control points,
Laplacian Eigenmaps (\code{\link{do.lapeig}}) is then applied to high-dimensional data points
lying in neighborhoods of each control point. Embedded low-dimensional local manifold is then
aligned to match their coordinates as of their counterparts from classical MDS.
}
\section{Notes}{

\emph{Random Control Points} : The performance of embedding using PLP heavily relies on
selection of control points, which is contingent on the performance of \eqn{k}-means
clustering.

\emph{User Interruption} : PLP is actually an interactive algorithm that a user should be able to intervene
intermittently. Such functionality is, however, sacrificed in this version.
}

\examples{
## generate default dataset
X <- aux.gensamples()

## run 5 times under the same setting
par(mfrow=c(1,5))
for (i in 1:5){
    out = do.plp(X,ndim=2,type=c("proportion",0.2))
    pm  = paste("iteration ",i,sep="")
    plot(out$Y[,1],out$Y[,2],main=pm)
}

}
\references{
\insertRef{paulovich_piece_2011}{Rdimtools}
}
\author{
Kisung You
}
